/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.AcceptPanelRenderedBlock;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.PanelRenderedBlock;
import br.com.linkcom.neo.view.template.PropertyConfigTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelGridTag
extends BaseTag
implements AcceptPanelRenderedBlock {
    protected List<PanelRenderedBlock> blocks = new ArrayList<PanelRenderedBlock>();
    protected Integer columns = null;
    protected String style;
    protected String styleClass;
    protected String rowStyleClasses;
    protected String rowStyles;
    protected String columnStyleClasses;
    protected String columnStyles;
    protected Integer colspan;
    protected Boolean propertyRenderAsDouble;
    protected Boolean useParentPanelGridProperties = true;
    Iterator<String> rowStyleIterator;
    Iterator<String> rowStyleClassIterator;
    Iterator<String> columnStyleIterator;
    Iterator<String> columnStyleClassIterator;

    @Override
    protected void doComponent() throws Exception {
        PanelGridTag parentPanel;
        if (Util.booleans.isTrue(this.useParentPanelGridProperties) && (parentPanel = this.findParent(PanelGridTag.class)) != null) {
            if (Util.strings.isEmpty(this.style)) {
                this.style = parentPanel.getStyle();
            }
            if (Util.strings.isEmpty(this.styleClass)) {
                this.styleClass = parentPanel.getStyleClass();
            }
            if (Util.strings.isEmpty(this.rowStyleClasses)) {
                this.rowStyleClasses = parentPanel.getRowStyleClasses();
            }
            if (Util.strings.isEmpty(this.rowStyles)) {
                this.rowStyles = parentPanel.getRowStyles();
            }
            if (Util.strings.isEmpty(this.columnStyleClasses)) {
                this.columnStyleClasses = parentPanel.getColumnStyleClasses();
            }
            if (Util.strings.isEmpty(this.columnStyles)) {
                this.columnStyles = parentPanel.getColumnStyles();
            }
        }
        if (this.columns == null || this.columns == 0) {
            this.columns = 1;
        }
        if (!Util.numbers.isPositive(this.columns)) {
            throw new IllegalArgumentException("O atributo columns da tag panelGrid deve ser positivo");
        }
        if (this.propertyRenderAsDouble == null) {
            BaseTag findFirst = this.findFirst(PropertyConfigTag.class, PanelGridTag.class);
            if (findFirst instanceof PropertyConfigTag) {
                this.propertyRenderAsDouble = "double".equals(((PropertyConfigTag)findFirst).getRenderAs());
            } else if (findFirst instanceof PanelGridTag) {
                Boolean propertyRenderAsDouble;
                this.propertyRenderAsDouble = propertyRenderAsDouble = ((PanelGridTag)findFirst).getPropertyRenderAsDouble();
            }
        }
        this.doBody();
        String styleString = this.style != null ? " style=\"" + this.style + "\"" : "";
        String classString = this.styleClass != null ? " class=\"" + this.styleClass + "\"" : "";
        this.getOut().println("<table" + styleString + classString + this.getDynamicAttributesToString() + ">");
        this.rowStyleIterator = this.getRowStyleIterator();
        this.rowStyleClassIterator = this.getRowStyleClassIterator();
        this.columnStyleIterator = this.getColumnStyleIterator();
        this.columnStyleClassIterator = this.getColumnStyleClassIterator();
        int remainingColumns = this.columns;
        int rowCount = 0;
        for (PanelRenderedBlock block : this.blocks) {
            String styleClass;
            String style;
            Integer colspanColumn = Util.numbers.asInteger(block.getProperties().get("colspan"), 1);
            if (remainingColumns <= 0) {
                remainingColumns = this.columns;
                this.getOut().println("</tr>");
            }
            if (remainingColumns == this.columns) {
                style = this.rowStyleIterator.next();
                styleClass = this.rowStyleClassIterator.next();
                String styleString2 = style != null ? " style=\"" + style + "\"" : "";
                String classString2 = styleClass != null ? " class=\"" + styleClass + "\"" : "";
                this.getOut().print("<tr" + styleString2 + classString2 + ">");
                ++rowCount;
            }
            style = this.columnStyleIterator.next();
            styleClass = this.columnStyleClassIterator.next();
            String styleClasses = String.valueOf(styleClass != null ? styleClass : "") + " ";
            if (block.getProperties().containsKey("class")) {
                Object remove = block.getProperties().remove("class");
                styleClasses = String.valueOf(styleClasses) + remove;
            }
            String styleString3 = style != null ? " style=\"" + style + "\"" : "";
            String classString3 = styleClass != null ? " class=\"" + styleClasses + "\"" : "";
            this.getOut().print("<td" + styleString3 + classString3 + this.getDynamicAttributesToString(block.getProperties()) + ">");
            this.getOut().print(block.body);
            this.getOut().println("</td>");
            if (colspanColumn > 1) {
                int i = 0;
                while (i < colspanColumn - 1) {
                    this.columnStyleClassIterator.next();
                    ++i;
                }
            }
            remainingColumns -= Math.max(colspanColumn, 1);
        }
        while (remainingColumns-- > 0 && rowCount > 1) {
            this.getOut().print("<td>");
            this.getOut().print("<!-- BLOCO VAZIO (N\u00e3o existe panels suficientes dentro do panel grid para satisfazer todas as colunas, ent\u00e3o esse panel foi criado para n\u00e3o quebrar a tabela) -->");
            this.getOut().println("</td>");
        }
        this.getOut().println("</tr>");
        this.getOut().println("</table>");
    }

    private Iterator<String> getRowStyleClassIterator() {
        if (Util.strings.isEmpty(this.rowStyleClasses)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.rowStyleClasses.split(","));
    }

    private Iterator<String> getRowStyleIterator() {
        if (Util.strings.isEmpty(this.rowStyles)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.rowStyles.split(","));
    }

    private Iterator<String> getColumnStyleClassIterator() {
        if (Util.strings.isEmpty(this.columnStyleClasses)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.columnStyleClasses.split(","));
    }

    private Iterator<String> getColumnStyleIterator() {
        if (Util.strings.isEmpty(this.columnStyles)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.columnStyles.split(","));
    }

    public String getRowStyleClasses() {
        return this.rowStyleClasses;
    }

    public String getRowStyles() {
        return this.rowStyles;
    }

    public String getStyle() {
        return this.style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setRowStyleClasses(String rowStyleClasses) {
        this.rowStyleClasses = rowStyleClasses;
    }

    public void setRowStyles(String rowStyles) {
        this.rowStyles = rowStyles;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    @Override
    public boolean addBlock(PanelRenderedBlock o) {
        return this.blocks.add(o);
    }

    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public String getColumnStyleClasses() {
        return this.columnStyleClasses;
    }

    public String getColumnStyles() {
        return this.columnStyles;
    }

    public void setColumnStyleClasses(String columnStyleClasses) {
        this.columnStyleClasses = columnStyleClasses;
    }

    public void setColumnStyles(String columnStyles) {
        this.columnStyles = columnStyles;
    }

    public Integer getColspan() {
        return this.colspan;
    }

    public void setColspan(Integer colspan) {
        this.colspan = colspan;
    }

    @Override
    protected void addPanelProperties(Map<String, Object> properties) {
        properties.put("colspan", this.colspan);
    }

    public Boolean getPropertyRenderAsDouble() {
        return this.propertyRenderAsDouble;
    }

    public void setPropertyRenderAsDouble(Boolean propertyRenderAsDouble) {
        this.propertyRenderAsDouble = propertyRenderAsDouble;
    }

    public Boolean getUseParentPanelGridProperties() {
        return this.useParentPanelGridProperties;
    }

    public void setUseParentPanelGridProperties(Boolean useParentPanelGridProperties) {
        this.useParentPanelGridProperties = useParentPanelGridProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CyclicIterator
    implements Iterator<String> {
        private String[] strings;
        int i = 0;

        public CyclicIterator(String[] strings) {
            this.strings = strings;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (this.strings == null || this.strings.length == 0) {
                return null;
            }
            if (this.i >= this.strings.length) {
                this.i = 0;
            }
            return this.strings[this.i++];
        }

        public String[] getStrings() {
            return this.strings;
        }

        @Override
        public void remove() {
        }
    }
}

