/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.types.File;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.DownloadFileServlet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OutputTag
extends BaseTag {
    protected Object value;
    protected String pattern;
    protected String itemSeparator;
    protected String styleClass;
    protected String style;
    protected String trueFalseNullLabels = "Sim,N\u00e3o,";
    protected boolean escapeHTML = false;

    public boolean isEscapeHTML() {
        return this.escapeHTML;
    }

    public void setEscapeHTML(boolean escapeHTML) {
        this.escapeHTML = escapeHTML;
    }

    public String getTrueFalseNullLabels() {
        return this.trueFalseNullLabels;
    }

    public void setTrueFalseNullLabels(String trueFalseNullLabels) {
        this.trueFalseNullLabels = trueFalseNullLabels;
    }

    protected void doComponent() throws Exception {
        if (this.style != null || this.styleClass != null) {
            this.getOut().print("<span");
            if (this.style != null) {
                this.getOut().print(" style='" + this.style + "'");
            }
            if (this.styleClass != null) {
                this.getOut().print(" class='" + this.styleClass + "'");
            }
            this.getOut().print(">");
        }
        if (this.value == null) {
            this.value = this.getPageContext().findAttribute("value");
        }
        try {
            if ((this.value instanceof Boolean || this.value == null) && Util.strings.isNotEmpty(this.trueFalseNullLabels)) {
                String[] split = this.trueFalseNullLabels.split(",");
                String trueString = split[0];
                String falseString = split[1];
                String nullString = "";
                if (split.length == 3) {
                    nullString = split[2];
                }
                if (this.value == null) {
                    this.value = nullString;
                } else if (this.value instanceof Boolean) {
                    this.value = ((Boolean)this.value).booleanValue() ? trueString : falseString;
                }
            } else if (this.value instanceof Boolean) {
                this.value = ((Boolean)this.value).booleanValue() ? "Sim" : "N\u00e3o";
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NeoException("trueFalseNullLabels inv\u00e1lido " + this.trueFalseNullLabels + ". Esse atributo deve ser uma string separada por v\u00edrgula indicando o valor de TRUE FALSE e NULL. ex.: sim,n\u00e3o,vazio");
        }
        if ((this.value instanceof Date || this.value instanceof java.sql.Date || this.value instanceof Timestamp) && Util.strings.isEmpty(this.pattern)) {
            this.pattern = "dd/MM/yyyy";
        }
        if (this.pattern != null) {
            if (this.value instanceof Date || this.value instanceof java.sql.Date || this.value instanceof Timestamp) {
                String valueToString = new SimpleDateFormat(this.pattern).format(this.value);
                this.getOut().print(valueToString);
            } else if (this.value instanceof Number) {
                Number number = (Number)this.value;
                String valueToString = new DecimalFormat(this.pattern).format(number);
                this.getOut().print(valueToString);
            } else {
                this.getOut().print(this.getObjectDescriptionToString(this.value));
            }
        } else if (this.value instanceof File) {
            File file = (File)this.value;
            DownloadFileServlet.addCdfile(this.getRequest().getSession(), file.getCdfile());
            this.getOut().print("<a href=\"" + this.getRequest().getContextPath() + "/DOWNLOADFILE" + "/" + file.getCdfile() + "\">");
            this.getOut().print(file.getName());
            this.getOut().print("</a>");
        } else {
            String objectDescriptionToString = this.getObjectDescriptionToString(this.value);
            if (objectDescriptionToString != null) {
                this.getOut().print(objectDescriptionToString.replaceAll("<", "&lt;").replaceAll("\n", "<BR>"));
            }
        }
        if (this.style != null || this.styleClass != null) {
            this.getOut().print("</span>");
        }
    }

    public String getItemSeparator() {
        return this.itemSeparator;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getStyle() {
        return this.style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public Object getValue() {
        return this.value;
    }

    public void setItemSeparator(String itemSeparator) {
        this.itemSeparator = itemSeparator;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

