/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;

public class HasAuthorizationTag
extends BaseTag {
    protected String url;
    protected String action = "";

    protected void doComponent() throws Exception {
        if (this.action != null && this.action.contains(",")) {
            String[] split = this.action.split(",");
            boolean hasAuthorization = false;
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (this.hasAuthorization(string)) {
                    hasAuthorization = true;
                }
                ++n2;
            }
            if (hasAuthorization) {
                this.doBody();
            }
        } else if (this.hasAuthorization(this.action)) {
            this.doBody();
        }
    }

    private boolean hasAuthorization(String action) {
        try {
            String partialURL = this.getPartialURL();
            if (partialURL.contains("?")) {
                partialURL = partialURL.substring(0, partialURL.indexOf(63));
            }
            return Neo.getApplicationContext().getAuthorizationManager().isAuthorized(partialURL, action, Neo.getUser());
        }
        catch (Exception e) {
            throw new NeoException("Problema ao verificar autoriza\u00e7\u00e3o", e);
        }
    }

    private String getPartialURL() {
        if (this.url != null && this.url.startsWith(this.getRequest().getContextPath())) {
            return this.url.substring(this.getRequest().getContextPath().length());
        }
        String fullUrl = this.url == null ? Util.web.getFirstUrl() : (this.url.startsWith("/") ? this.url : this.url);
        return fullUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAction() {
        return this.action;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

