/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.DataGridTag;
import br.com.linkcom.neo.view.PanelRenderedBlock;
import java.util.HashMap;
import java.util.Set;

public class ColumnTag
extends BaseTag {
    public static final String REGISTERING_DATAGRID = "REGISTERING_DATAGRID";
    protected String header;
    protected String order;
    protected DataGridTag dataGrid;
    protected boolean hasBodyTag = false;

    public void setHasBodyTag(boolean hasBodyTag) {
        this.hasBodyTag = hasBodyTag;
    }

    protected void doComponent() throws Exception {
        if (this.dataGrid == null) {
            this.dataGrid = this.findParent2(DataGridTag.class, true);
        }
        HashMap<String, Object> mapHeader = new HashMap<String, Object>();
        HashMap<String, Object> mapBody = new HashMap<String, Object>();
        Set<String> keySet = this.getDynamicAttributesMap().keySet();
        for (String string : keySet) {
            if (string.startsWith("body")) {
                mapBody.put(string.substring("body".length()), this.getDynamicAttributesMap().get(string));
                continue;
            }
            if (string.startsWith("header")) {
                mapHeader.put(string.substring("header".length()), this.getDynamicAttributesMap().get(string));
                continue;
            }
            mapBody.put(string, this.getDynamicAttributesMap().get(string));
            mapHeader.put(string, this.getDynamicAttributesMap().get(string));
        }
        if (this.dataGrid.getCurrentStatus() == DataGridTag.Status.REGISTER) {
            this.pushAttribute(REGISTERING_DATAGRID, true);
        }
        String tagBody = null;
        if (this.dataGrid.getCurrentStatus() != DataGridTag.Status.HEADER || this.header == null) {
            tagBody = this.getBody();
        }
        if (this.dataGrid.getCurrentStatus() == DataGridTag.Status.REGISTER) {
            this.popAttribute(REGISTERING_DATAGRID);
        }
        switch (this.dataGrid.getCurrentStatus()) {
            case HEADER: {
                if (Util.strings.isEmpty(tagBody) && this.header == null) {
                    this.getOut().print("<td" + this.getDynamicAttributesToString(mapHeader) + "> </td>");
                    break;
                }
                if (this.header == null) {
                    this.getOut().print(tagBody);
                    break;
                }
                if (this.order == null) {
                    this.getOut().print("<td" + this.getDynamicAttributesToString(mapHeader) + ">" + this.header + "</td>");
                    break;
                }
                this.getOut().print("<td" + this.getDynamicAttributesToString(mapHeader) + ">" + "<a class=\"order\" href=\"" + this.getRequest().getContextPath() + NeoWeb.getRequestContext().getRequestQuery() + "?orderBy=" + this.order + "\">" + this.header + "</a>" + "</td>");
                break;
            }
            case BODY: {
                if (!this.hasBodyTag) {
                    this.getOut().print("<td" + this.getDynamicAttributesToString(mapBody) + ">");
                    this.getOut().print(tagBody == null || tagBody.trim().equals("") ? "&nbsp;" : tagBody);
                    this.getOut().print("</td>");
                    break;
                }
                this.getOut().print(tagBody);
                break;
            }
            case DYNALINE: {
                PanelRenderedBlock block = new PanelRenderedBlock();
                block.setBody(tagBody);
                this.dataGrid.add(block);
                break;
            }
            case FOOTER: {
                if (Util.strings.isEmpty(tagBody)) {
                    this.getOut().print("<td" + this.getDynamicAttributesToString() + "> </td>");
                    break;
                }
                this.getOut().print(tagBody);
                break;
            }
            case REGISTER: {
                if (this.header != null) {
                    this.dataGrid.setRenderHeader(true);
                }
                this.dataGrid.setHasColumns(true);
            }
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

