/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.annotation.DescriptionProperty;
import br.com.linkcom.neo.bean.editors.CalendarEditor;
import br.com.linkcom.neo.bean.editors.HoraPropertyEditor;
import br.com.linkcom.neo.bean.editors.MoneyPropertyEditor;
import br.com.linkcom.neo.bean.editors.TimePropertyEditor;
import br.com.linkcom.neo.bean.editors.TimestampPropertyEditor;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.TagNotFoundException;
import br.com.linkcom.neo.persistence.QueryBuilder;
import br.com.linkcom.neo.types.Hora;
import br.com.linkcom.neo.types.Money;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.ColumnChildTag;
import br.com.linkcom.neo.view.GetContentTag;
import br.com.linkcom.neo.view.InputListener;
import br.com.linkcom.neo.view.InputTag;
import br.com.linkcom.neo.view.LogicalTag;
import br.com.linkcom.neo.view.MaxLengthInputListener;
import br.com.linkcom.neo.view.OgnlExpressionParser;
import br.com.linkcom.neo.view.PanelGridTag;
import br.com.linkcom.neo.view.PanelRenderedBlock;
import br.com.linkcom.neo.view.PanelTag;
import br.com.linkcom.neo.view.WebContextMap;
import br.com.linkcom.neo.view.WrappedWriterResponse;
import br.com.linkcom.neo.view.YearInputListener;
import java.beans.PropertyEditor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.Id;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LazyInitializationException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTag
extends SimpleTagSupport
implements DynamicAttributes {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String id;
    protected Boolean printWhen;
    private String STACK_ATTRIBUTE_NAME = "TagStack";
    public String TAG_ATTRIBUTE = "tag";
    private Map<String, Object> dynamicAttributesMap = new HashMap<String, Object>();
    private static Map<String, String[]> templateCache = new HashMap<String, String[]>();
    private static Set<String> templates = new HashSet<String>();
    private BaseTag parent;
    protected Map<Class<?>, PropertyEditor> propertyEditors = new HashMap();
    protected Map<Class<? extends Annotation>, InputListener<? extends Annotation>> inputListeners = new HashMap<Class<? extends Annotation>, InputListener<? extends Annotation>>();

    public Boolean getPrintWhen() {
        return this.printWhen;
    }

    public void setPrintWhen(Boolean printWhen) {
        this.printWhen = printWhen;
    }

    public void registerPropertyEditor(Class<?> class1, PropertyEditor editor) {
        this.propertyEditors.put(class1, editor);
    }

    public void registerInputListener(InputListener<? extends Annotation> inputListener) {
        this.inputListeners.put(inputListener.getAnnotationType(), inputListener);
    }

    public <A extends Annotation> InputListener<A> getInputListener(A annotation) {
        InputListener<? extends Annotation> inputListener = this.inputListeners.get(annotation.annotationType());
        if (inputListener == null) {
            return new InputListener(){

                public void onRender(InputTag input, Annotation annotation) {
                }

                public Class getAnnotationType() {
                    return null;
                }
            };
        }
        return inputListener;
    }

    public String generateUniqueId() {
        Integer idsequence = (Integer)this.getRequest().getAttribute("IDSEQUENCE");
        if (idsequence == null) {
            idsequence = 0;
        }
        this.getRequest().setAttribute("IDSEQUENCE", (Object)(idsequence + 1));
        return "" + (char)(Math.random() * 20.0 + 65.0) + idsequence;
    }

    public BaseTag() {
        DecimalFormat numberFormat = new DecimalFormat("#.##############");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        boolean allowEmpty = true;
        this.registerPropertyEditor(Boolean.class, (PropertyEditor)new CustomBooleanEditor(false));
        this.registerPropertyEditor(Short.class, (PropertyEditor)new CustomNumberEditor(Short.class, false));
        this.registerPropertyEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, false));
        this.registerPropertyEditor(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, false));
        this.registerPropertyEditor(BigInteger.class, (PropertyEditor)new CustomNumberEditor(BigInteger.class, false));
        this.registerPropertyEditor(Float.class, (PropertyEditor)new CustomNumberEditor(Float.class, (NumberFormat)numberFormat, false));
        this.registerPropertyEditor(Double.class, (PropertyEditor)new CustomNumberEditor(Double.class, (NumberFormat)numberFormat, false));
        this.registerPropertyEditor(BigDecimal.class, (PropertyEditor)new CustomNumberEditor(BigDecimal.class, (NumberFormat)numberFormat, false));
        this.registerPropertyEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)simpleDateFormat, true));
        this.registerPropertyEditor(Calendar.class, (PropertyEditor)((Object)new CalendarEditor(simpleDateFormat, true)));
        this.registerPropertyEditor(GregorianCalendar.class, (PropertyEditor)((Object)new CalendarEditor(simpleDateFormat, true)));
        this.registerPropertyEditor(java.sql.Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)simpleDateFormat, true));
        this.registerPropertyEditor(Time.class, new TimePropertyEditor());
        this.registerPropertyEditor(Hora.class, new HoraPropertyEditor());
        this.registerPropertyEditor(Timestamp.class, new TimestampPropertyEditor());
        this.registerPropertyEditor(Money.class, new MoneyPropertyEditor());
        this.registerInputListener(new MaxLengthInputListener());
        this.registerInputListener(new YearInputListener());
    }

    public BaseTag getParent() {
        return this.parent;
    }

    protected String escape(String opValue) {
        if (opValue == null) {
            return null;
        }
        return opValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
    }

    protected String escapeSingleQuotes(String opValue) {
        if (opValue == null) {
            return null;
        }
        return opValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
    }

    protected void pushAttribute(String name, Object value) {
        this.getStack(String.valueOf(name) + "_stack").push(value);
        this.getRequest().setAttribute(name, value);
    }

    private Stack getStack(String string) {
        Stack stack = (Stack)this.getRequest().getAttribute(string);
        if (stack == null) {
            stack = new Stack();
            this.getRequest().setAttribute(string, stack);
        }
        return stack;
    }

    protected Object popAttribute(String name) {
        Stack stack = this.getStack(String.valueOf(name) + "_stack");
        Object pop = stack.pop();
        if (!stack.isEmpty()) {
            this.getRequest().setAttribute(name, stack.peek());
        } else {
            this.getRequest().setAttribute(name, null);
        }
        return pop;
    }

    protected final void doBody() throws JspException, IOException {
        if (this.getJspBody() != null) {
            try {
                this.getJspBody().invoke((Writer)this.getOut());
            }
            catch (Exception e) {
                this.printException(e);
            }
        }
    }

    private void printException(Exception e) throws IOException {
        String extype = "";
        if (e.getClass().getName().startsWith("java.lang")) {
            extype = String.valueOf(e.getClass().getSimpleName()) + ": ";
        }
        this.getOut().println("<font color=\"red\">" + extype + "<b>" + e.getMessage() + "</b>" + "</font>");
        Throwable cause = this.getNextException(e);
        while (cause != null) {
            this.getOut().println("<font color=\"red\">" + cause.getMessage() + "</font>");
            cause = this.getNextException(cause);
        }
        e.printStackTrace();
    }

    private Throwable getNextException(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof ServletException) {
            if (e.getCause() != null && e.getCause() != e) {
                return e.getCause();
            }
            return ((ServletException)e).getRootCause();
        }
        return e.getCause();
    }

    protected String getObjectValueToString(Object value, boolean includeDescription) {
        if (value == null) {
            return "";
        }
        PropertyEditor propertyEditor = this.propertyEditors.get(value.getClass());
        try {
            if (propertyEditor != null) {
                propertyEditor.setValue(value);
                return propertyEditor.getAsText();
            }
            if (this.hasId(value.getClass())) {
                return Util.strings.toStringIdStyled(value, includeDescription);
            }
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            return value.toString();
        }
        catch (LazyInitializationException e) {
            String id = "";
            try {
                id = Util.strings.toStringIdStyled(value, false);
            }
            catch (LazyInitializationException lazyInitializationException) {
                // empty catch block
            }
            return String.valueOf(value.getClass().getSimpleName()) + " [N\u00e3o foi poss\u00edvel fazer toString LazyInicializationException] " + id;
        }
        catch (InvalidPropertyException e1) {
            Object object = Neo.getApplicationContext().getConfig().getProperties().get("autoLoadOnView");
            if (object == null || "true".equalsIgnoreCase(object.toString())) {
                try {
                    this.log.warn((Object)("Perda de performance! Carregando objeto sob demanda " + value.getClass()));
                    if (value != null && value.getClass().getName().contains("$$") && e1.getCause().getCause() instanceof LazyInitializationException) {
                        value = new QueryBuilder(Neo.getObject(HibernateTemplate.class)).from(value.getClass().getSuperclass()).entity(value).unique();
                        return this.getObjectValueToString(value, includeDescription);
                    }
                    throw e1;
                }
                catch (NullPointerException e) {
                    throw e1;
                }
            }
            throw e1;
        }
    }

    protected String getObjectValueToString(Object value) {
        return this.getObjectValueToString(value, false);
    }

    protected boolean hasId(Class<? extends Object> class1) {
        if (class1.getName().contains("$$")) {
            class1 = class1.getSuperclass();
        }
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        while (class1 != null && !class1.equals(Object.class)) {
            Method[] methods;
            Method[] methodArray = methods = reflectionCache.getMethods(class1);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (reflectionCache.isAnnotationPresent(method, Id.class)) {
                    return true;
                }
                ++n2;
            }
            class1 = class1.getSuperclass();
        }
        return false;
    }

    protected String getObjectDescriptionToString(Object value) {
        if (value == null) {
            return "";
        }
        PropertyEditor propertyEditor = this.propertyEditors.get(value.getClass());
        try {
            if (propertyEditor != null) {
                propertyEditor.setValue(value);
                return propertyEditor.getAsText();
            }
            if (this.hasDescriptionProperty(value.getClass())) {
                return Util.strings.toStringDescription(value);
            }
            return value.toString();
        }
        catch (LazyInitializationException e) {
            return String.valueOf(value.getClass().getSimpleName()) + " [N\u00e3o foi poss\u00edvel fazer toString LazyInicializationException]";
        }
        catch (InvalidPropertyException e1) {
            Object object = Neo.getApplicationContext().getConfig().getProperties().get("autoLoadOnView");
            if (object == null || "true".equalsIgnoreCase(object.toString())) {
                this.log.warn((Object)("Perda de performance! Carregando objeto sob demanda " + value.getClass()));
                try {
                    if (value != null && value.getClass().getName().contains("$$") && e1.getCause().getCause() instanceof LazyInitializationException) {
                        value = new QueryBuilder(Neo.getObject(HibernateTemplate.class)).from(value.getClass().getSuperclass()).entity(value).unique();
                        return this.getObjectDescriptionToString(value);
                    }
                    throw e1;
                }
                catch (NullPointerException e) {
                    throw e1;
                }
            }
            if (e1.getCause() instanceof InvocationTargetException && ((InvocationTargetException)e1.getCause()).getTargetException() instanceof LazyInitializationException) {
                throw new RuntimeException("N\u00e3o foi poss\u00edvel fazer ObjectDescriptionToString de " + value.getClass().getSimpleName() + ". (Talvez seja necess\u00e1rio um fetch)", e1);
            }
            throw e1;
        }
    }

    private boolean hasDescriptionProperty(Class<? extends Object> class1) {
        if (class1.getName().contains("$$")) {
            class1 = class1.getSuperclass();
        }
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        while (!class1.equals(Object.class)) {
            Method[] methods;
            Method[] methodArray = methods = reflectionCache.getMethods(class1);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (reflectionCache.isAnnotationPresent(method, DescriptionProperty.class)) {
                    return true;
                }
                ++n2;
            }
            class1 = class1.getSuperclass();
        }
        return false;
    }

    public String getBody() throws JspException, IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(arrayOutputStream);
        this.getJspBody().invoke((Writer)writer);
        writer.flush();
        return arrayOutputStream.toString();
    }

    protected JspWriter getOut() {
        return this.getPageContext().getOut();
    }

    protected <E> E findParent(Class<E> tagClass) {
        return this.findParent(tagClass, false);
    }

    public BaseTag findFirst(Class<? extends BaseTag> ... classes) {
        List<BaseTag> tags = this.getTagsFromTopToThis();
        boolean found = false;
        Iterator<BaseTag> iter = tags.iterator();
        while (iter.hasNext()) {
            BaseTag element = iter.next();
            if (element == this) {
                found = true;
            }
            if (!found) continue;
            iter.remove();
        }
        Collections.reverse(tags);
        List<Class<? extends BaseTag>> asList = Arrays.asList(classes);
        for (BaseTag tag : tags) {
            if (!asList.contains(((Object)((Object)tag)).getClass())) continue;
            return tag;
        }
        return null;
    }

    protected BaseTag findFirst2(Class ... classes) {
        List<BaseTag> tags = this.getTagsFromThisToTop();
        tags.remove(0);
        List<Class> asList = Arrays.asList(classes);
        for (BaseTag tag : tags) {
            for (Class class1 : asList) {
                if (!class1.isAssignableFrom(((Object)((Object)tag)).getClass())) continue;
                return tag;
            }
        }
        return null;
    }

    protected List<BaseTag> getTagsFromThisToTop() {
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.addAll(this.getTagStack());
        Collections.reverse(tags);
        return tags;
    }

    protected List<BaseTag> getTagsFromTopToThis() {
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.addAll(this.getTagStack());
        return tags;
    }

    protected <E> E findParent(Class<E> tagClass, boolean throwExceptionIfNotFound) throws TagNotFoundException {
        Stack<BaseTag> tagStack = this.getTagStack();
        int i = tagStack.size() - 2;
        while (i >= 0) {
            BaseTag baseTag = (BaseTag)((Object)tagStack.get(i));
            if (tagClass.equals(((Object)((Object)baseTag)).getClass())) {
                return (E)((Object)baseTag);
            }
            --i;
        }
        if (throwExceptionIfNotFound) {
            throw new TagNotFoundException("A tag " + ((Object)((Object)this)).getClass().getName() + " tentou procurar uma tag " + tagClass.getName() + " mas n\u00e3o encontrou. Provavelmente \u00e9 obrigat\u00f3rio a tag " + ((Object)((Object)this)).getClass().getName() + " estar aninhada a uma tag " + tagClass.getName());
        }
        return null;
    }

    protected <E> E findParent2(Class<E> tagClass, boolean throwExceptionIfNotFound) throws TagNotFoundException {
        Stack<BaseTag> tagStack = this.getTagStack();
        int i = tagStack.size() - 2;
        while (i >= 0) {
            BaseTag baseTag = (BaseTag)((Object)tagStack.get(i));
            if (tagClass.isAssignableFrom(((Object)((Object)baseTag)).getClass())) {
                return (E)((Object)baseTag);
            }
            --i;
        }
        if (throwExceptionIfNotFound) {
            throw new TagNotFoundException("A tag " + ((Object)((Object)this)).getClass().getName() + " tentou procurar uma tag " + tagClass.getName() + " mas n\u00e3o encontrou.");
        }
        return null;
    }

    public final void doTag() throws JspException, IOException {
        block14: {
            boolean registeringDataGrid;
            if (Boolean.FALSE.equals(this.printWhen)) {
                return;
            }
            boolean bl = registeringDataGrid = this.getRequest().getAttribute("REGISTERING_DATAGRID") != null;
            if (registeringDataGrid && !(this instanceof ColumnChildTag)) {
                return;
            }
            if (!this.getTagStack().isEmpty()) {
                this.parent = this.getTagStack().peek();
            }
            try {
                this.colocaTagNaPilha();
                BaseTag parent = this.getParent();
                while (parent != null && parent instanceof LogicalTag) {
                    parent = parent.getParent();
                }
                PanelGridTag panelGrid = parent instanceof PanelGridTag ? (PanelGridTag)parent : null;
                GetContentTag getContent = this.findParent(GetContentTag.class);
                if (getContent != null && getContent.getTag(this)) {
                    this.doTagInGetContent(getContent);
                    break block14;
                }
                if (panelGrid != null && !(this instanceof PanelTag) && !(this instanceof LogicalTag)) {
                    this.doTagInPanelGrid(panelGrid);
                    break block14;
                }
                try {
                    this.doComponent();
                }
                catch (JspException e) {
                    throw e;
                }
                catch (Exception e) {
                    try {
                        this.printException(e);
                    }
                    catch (IOException e1) {
                        throw new JspException((Throwable)e);
                    }
                }
            }
            finally {
                this.tiraTagDaPilha();
            }
        }
    }

    protected void doTagInGetContent(GetContentTag getContent) throws JspException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.getPageContext().pushBody((Writer)printWriter);
        try {
            this.doComponent();
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        this.getPageContext().popBody();
        printWriter.flush();
        String body = outputStream.toString();
        getContent.register(body);
    }

    private void doTagInPanelGrid(PanelGridTag panelGrid) throws JspException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.getPageContext().pushBody((Writer)printWriter);
        try {
            this.doComponent();
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        this.getPageContext().popBody();
        printWriter.flush();
        String body = outputStream.toString();
        PanelRenderedBlock block = new PanelRenderedBlock();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.addBasicPanelProperties(properties);
        this.addPanelProperties(properties);
        block.setBody(body);
        block.setProperties(properties);
        panelGrid.addBlock(block);
    }

    protected void addBasicPanelProperties(Map<String, Object> properties) {
        Set<String> keySet = this.dynamicAttributesMap.keySet();
        for (String string : keySet) {
            if (!string.startsWith("panel")) continue;
            properties.put(string.substring("panel".length()), this.dynamicAttributesMap.get(string));
        }
    }

    protected void addPanelProperties(Map<String, Object> properties) {
    }

    protected void doComponent() throws Exception {
    }

    private void colocaTagNaPilha() {
        this.getTagStack().add(this);
    }

    private void tiraTagDaPilha() {
        this.getTagStack().pop();
    }

    protected Stack<BaseTag> getTagStack() {
        Stack stack = (Stack)this.getRequest().getAttribute(this.STACK_ATTRIBUTE_NAME);
        if (stack == null) {
            stack = new Stack();
            this.getRequest().setAttribute(this.STACK_ATTRIBUTE_NAME, stack);
        }
        return stack;
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getPageContext().getRequest();
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)this.getPageContext().getResponse();
    }

    protected ServletContext getServletContext() {
        return this.getPageContext().getServletContext();
    }

    protected PageContext getPageContext() {
        return (PageContext)this.getJspContext();
    }

    protected void includeTextTemplate() throws ServletException, IOException, ELException, JspException {
        String url = "/WEB-INF/classes/" + this.getTemplateName() + ".jsp";
        this.verificarTemplate(null);
        this.includeTextTemplateFile(url);
    }

    protected void includeTextTemplate(String suffix) throws ServletException, IOException, ELException, JspException {
        String url = "/WEB-INF/classes/" + this.getTemplateName() + "-" + suffix + ".jsp";
        this.verificarTemplate(suffix);
        this.includeTextTemplateFile(url);
    }

    private void verificarTemplate(String suffix) {
        String template = null;
        template = suffix == null ? String.valueOf(this.getTemplateName()) + ".jsp" : String.valueOf(this.getTemplateName()) + "-" + suffix + ".jsp";
        if (templates.contains(template)) {
            return;
        }
        String url = "/WEB-INF/classes/" + template;
        try {
            URL resource = this.getServletContext().getResource(url);
            if (resource == null) {
                String neoJarPath = this.getNeoJarPath();
                byte[] bytesTemplate = this.getTemplate(template, neoJarPath);
                this.writeTemplate(template, bytesTemplate);
            } else {
                templates.add(template);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeTemplate(String template, byte[] bytesTemplate) {
        if (bytesTemplate != null) {
            String realPath = this.getServletContext().getRealPath("/WEB-INF/classes");
            int lastSeparator = Math.max(template.lastIndexOf(92), template.lastIndexOf(47));
            String templatePath = template.substring(0, lastSeparator);
            File dir = new File(String.valueOf(realPath) + File.separator + templatePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File arquivo = new File(String.valueOf(realPath) + File.separator + template);
            try {
                FileOutputStream outputStream = new FileOutputStream(arquivo);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                int i = 0;
                while (i < bytesTemplate.length) {
                    bufferedOutputStream.write(bytesTemplate[i]);
                    ++i;
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (FileNotFoundException e) {
                this.log.warn((Object)("Arquivo n\u00e3o encontrado " + realPath + File.separator + template + "  " + e.getMessage()));
            }
            catch (IOException e) {
                this.log.warn((Object)("N\u00e3o foi poss\u00edvel escrever o arquivo " + realPath + File.separator + template + "  " + e.getMessage()));
            }
        }
    }

    private byte[] getTemplate(String template, String neoJarPath) {
        byte[] bytesTemplate = null;
        if (neoJarPath != null) {
            String root = this.getServletContext().getRealPath("/");
            try {
                ZipFile zipFile = new ZipFile(String.valueOf(root) + neoJarPath);
                ZipEntry entry = zipFile.getEntry(template);
                InputStream inputStreamTemplate = zipFile.getInputStream(entry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamTemplate);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)entry.getSize());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                int data = -1;
                while ((data = bufferedInputStream.read()) != -1) {
                    bufferedOutputStream.write(data);
                }
                bufferedInputStream.close();
                bufferedOutputStream.flush();
                bytesTemplate = byteArrayOutputStream.toByteArray();
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                this.log.warn((Object)("N\u00e3o foi poss\u00edvel copiar o template (" + neoJarPath + ") do jar do neo para a aplicacao. " + e.getMessage()));
            }
        }
        return bytesTemplate;
    }

    private String getNeoJarPath() {
        String neoJarPath = null;
        Set resourcePaths = this.getServletContext().getResourcePaths("/WEB-INF/lib");
        for (Object object : resourcePaths) {
            if (!object.toString().contains("neo") || !object.toString().endsWith(".jar")) continue;
            neoJarPath = object.toString();
            break;
        }
        return neoJarPath;
    }

    protected void includeJspTemplate() throws ServletException, IOException {
        String url = "/WEB-INF/classes/" + this.getTemplateName() + ".jsp";
        this.verificarTemplate(null);
        this.includeJspTemplateFile(url);
    }

    protected String getTemplateName() {
        return ((Object)((Object)this)).getClass().getName().replaceAll("\\.", "/");
    }

    protected void includeJspTemplate(String suffix) throws ServletException, IOException {
        String url = "/WEB-INF/classes/" + this.getTemplateName() + "-" + suffix + ".jsp";
        this.verificarTemplate(suffix);
        this.includeJspTemplateFile(url);
    }

    protected void includeTextTemplateFile(String template) throws ServletException, IOException, ELException, JspException {
        String[] text = templateCache.get(template);
        text = null;
        if (text == null) {
            InputStream resourceAsStream = this.getRequest().getSession().getServletContext().getResourceAsStream(template);
            if (resourceAsStream == null) {
                throw new IllegalArgumentException("Template " + template + " n\u00e3o encontrado!");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream));
            String line = null;
            String[] text2 = new String[]{"", ""};
            boolean first = true;
            int index = 0;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("<dobody/>")) {
                    String[] split = line.split("<dobody/>");
                    if (split.length > 0) {
                        int n = index;
                        text2[n] = String.valueOf(text2[n]) + split[0];
                    }
                    if (split.length > 1) {
                        int n = index + 1;
                        text2[n] = String.valueOf(text2[n]) + split[1];
                    }
                    ++index;
                    first = true;
                    continue;
                }
                if (!first) {
                    text2[index] = String.valueOf(text2[index]) + "\n";
                } else {
                    first = false;
                }
                text2[index] = String.valueOf(text2[index]) + line;
            }
            text = text2;
            templateCache.put(template, text);
        }
        Object last = this.getRequest().getAttribute(this.TAG_ATTRIBUTE);
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, (Object)this);
        this.evaluateAndPrint(text[0]);
        if (this.getJspBody() != null) {
            this.getJspBody().invoke(null);
        }
        if (!text[1].trim().equals("")) {
            this.evaluateAndPrint(text[1]);
        }
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, last);
    }

    protected void evaluateAndPrint(String expression) throws ELException, IOException {
        Object evaluate = this.getPageContext().getExpressionEvaluator().evaluate(expression, String.class, this.getPageContext().getVariableResolver(), null);
        this.getOut().print(evaluate);
    }

    protected Object evaluate(String expression) throws ELException {
        PageContext pageContext = this.getPageContext();
        return BaseTag.evaluate(expression, (JspContext)pageContext);
    }

    public static Object evaluate(String expression, JspContext pageContext) throws ELException {
        return pageContext.getExpressionEvaluator().evaluate(expression, Object.class, pageContext.getVariableResolver(), null);
    }

    protected void evaluateAndPrintIncludeTag(String expression) throws ELException, IOException {
        Object last = this.getRequest().getAttribute(this.TAG_ATTRIBUTE);
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, (Object)this);
        Object evaluate = this.getPageContext().getExpressionEvaluator().evaluate(expression, String.class, this.getPageContext().getVariableResolver(), null);
        this.getOut().print(evaluate);
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, last);
    }

    protected void includeJspTemplateFile(String template) throws ServletException, IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(arrayOutputStream);
        BaseTag.pushJspFragment(this.getRequest(), this.getJspBody());
        Object last = this.getRequest().getAttribute(this.TAG_ATTRIBUTE);
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, (Object)this);
        this.dispatchToTemplate(template, writer);
        writer.flush();
        this.getOut().write(arrayOutputStream.toString());
        this.getRequest().setAttribute(this.TAG_ATTRIBUTE, last);
        BaseTag.popJspFragment(this.getRequest());
    }

    public static JspFragment popJspFragment(HttpServletRequest request) {
        List<JspFragment> jspFragmentStack = BaseTag.getJspFragmentStack(request);
        return jspFragmentStack.remove(jspFragmentStack.size() - 1);
    }

    public static void pushJspFragment(HttpServletRequest request, JspFragment jspFragment) {
        List<JspFragment> jspFragmentStack = BaseTag.getJspFragmentStack(request);
        jspFragmentStack.add(jspFragment);
    }

    public static List<JspFragment> getJspFragmentStack(HttpServletRequest request) {
        ArrayList stack = (ArrayList)request.getAttribute("JSPFRAGMENT");
        if (stack == null) {
            stack = new ArrayList();
            request.setAttribute("JSPFRAGMENT", stack);
        }
        return stack;
    }

    private void dispatchToTemplate(String template, PrintWriter writer) throws ServletException, IOException {
        WrappedWriterResponse response = new WrappedWriterResponse(this.getResponse(), writer);
        RequestDispatcher requestDispatcher = null;
        requestDispatcher = this.getRequest().getRequestDispatcher(template);
        requestDispatcher.include((ServletRequest)this.getRequest(), (ServletResponse)response);
    }

    public Map<String, String[]> getTemplateCache() {
        return templateCache;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        if (localName != null) {
            localName = localName.toLowerCase();
        }
        this.dynamicAttributesMap.put(localName, value);
    }

    public Map<String, Object> getDynamicAttributesMap() {
        return this.dynamicAttributesMap;
    }

    protected boolean isEntity(Class c) {
        return this.hasId(c);
    }

    protected boolean areEqual(Object value1, Object value2) {
        boolean id = true;
        if (value1 == null) {
            return false;
        }
        id = this.hasId(value1.getClass()) && id;
        Class<?> class1 = value1.getClass();
        if (class1.getName().contains("$$")) {
            class1 = class1.getSuperclass();
        }
        if (value2 == null) {
            return false;
        }
        id = this.hasId(value2.getClass()) && id;
        Class<?> class2 = value2.getClass();
        if (class2.getName().contains("$$")) {
            class2 = class2.getSuperclass();
        }
        if (id) {
            boolean oneInstanceofOther;
            BeanDescriptor<Object> bd1 = Neo.getApplicationContext().getBeanDescriptor(value1);
            BeanDescriptor<Object> bd2 = Neo.getApplicationContext().getBeanDescriptor(value2);
            if (class1.equals(class2)) {
                return bd1.getId().equals(bd2.getId());
            }
            boolean bl = oneInstanceofOther = class1.isAssignableFrom(class2) || class2.isAssignableFrom(class1);
            if (oneInstanceofOther) {
                return bd1.getId().equals(bd2.getId());
            }
            return this.getObjectValueToString(value1, false).equals(this.getObjectValueToString(value2, false));
        }
        return value1.equals(value2);
    }

    public String getDynamicAttributesToString() {
        return this.getDynamicAttributesToString(this.dynamicAttributesMap);
    }

    public String getDynamicAttributesToString(Map<String, Object> dynamicAttributesMap) {
        StringBuilder builder = new StringBuilder(" ");
        Set<String> keySet = dynamicAttributesMap.keySet();
        for (String key : keySet) {
            builder.append(" ");
            builder.append(key);
            builder.append("=");
            builder.append("'");
            Object object = dynamicAttributesMap.get(key);
            if (object != null) {
                if (object instanceof String && ((String)object).startsWith("ognl:")) {
                    object = ((String)object).substring(5);
                    object = this.getOgnlValue((String)object);
                }
                object = object.toString();
            }
            builder.append(this.escapeSingleQuotes((String)object));
            builder.append("'");
        }
        String toString = builder.toString();
        return toString;
    }

    protected Object getOgnlValue(String expression) {
        WebContextMap contextMap = new WebContextMap(this.getRequest());
        Object value = OgnlExpressionParser.parse(expression, contextMap);
        return value;
    }

    protected <E> E getOgnlValue(String expression, Class<E> expectedType) {
        WebContextMap contextMap = new WebContextMap(this.getRequest());
        E value = OgnlExpressionParser.parse(expression, expectedType, contextMap);
        return value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDynamicAttributesMap(Map<String, Object> dynamicAttributesMap) {
        this.dynamicAttributesMap.putAll(dynamicAttributesMap);
    }
}

