/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.util;

import br.com.linkcom.neo.controller.ExtendedBeanWrapper;
import br.com.linkcom.neo.exception.NeoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtil {
    public boolean contains(Collection<?> collection, String property, Object value) throws NullPointerException {
        if (property == null) {
            throw new NullPointerException("O parametro property n\u00e3o deve ser nulo");
        }
        if (collection == null) {
            return false;
        }
        for (Object object : collection) {
            Object objectPropertyValue;
            block6: {
                if (object == null) continue;
                ExtendedBeanWrapper beanWrapper = new ExtendedBeanWrapper(object);
                try {
                    objectPropertyValue = beanWrapper.getPropertyValue(property);
                    if (objectPropertyValue != null) break block6;
                    if (object != null) continue;
                    return true;
                }
                catch (IllegalArgumentException e) {
                    throw new NeoException("Problema ao adquirir proprieade " + property + " do bean " + object, e);
                }
            }
            if (!objectPropertyValue.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static List<?> getListProperty(Collection<?> collection, String property) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<?> iter = collection.iterator();
        if (iter.hasNext()) {
            Object next = iter.next();
            ExtendedBeanWrapper beanWrapper = new ExtendedBeanWrapper(next);
            list.add(beanWrapper.getPropertyValue(property));
            while (iter.hasNext()) {
                try {
                    beanWrapper.setWrappedInstance(iter.next());
                    list.add(beanWrapper.getPropertyValue(property));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return list;
    }

    public Set<?> getSetProperty(Collection<?> collection, String property) {
        HashSet<Object> set = new HashSet<Object>();
        Iterator<?> iter = collection.iterator();
        if (iter.hasNext()) {
            Object next = iter.next();
            ExtendedBeanWrapper beanWrapper = new ExtendedBeanWrapper(next);
            set.add(beanWrapper.getPropertyValue(property));
            while (iter.hasNext()) {
                try {
                    beanWrapper.setWrappedInstance(iter.next());
                    set.add(beanWrapper.getPropertyValue(property));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return set;
    }

    public static String concatenate(Collection<?> collection, String token) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            builder.append(o);
            if (!iter.hasNext()) continue;
            builder.append(token);
        }
        return builder.toString();
    }

    public static String listAndConcatenate(Collection<?> collection, String property, String token) {
        return CollectionsUtil.concatenate(CollectionsUtil.getListProperty(collection, property), token);
    }

    public static boolean contains(Collection<?> collection, Object elem) {
        for (Object object : collection) {
            if (!(object != null ? elem != null && object.equals(elem) : elem == null)) continue;
            return true;
        }
        return false;
    }

    public String toString(Map<?, ?> mapa, String separadorConjunto, String separadorChaveValor) {
        StringBuilder builder = new StringBuilder();
        Set<?> keySet = mapa.keySet();
        Iterator<?> iter = keySet.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object != null) {
                builder.append(object.toString());
            }
            builder.append(separadorChaveValor);
            Object value = mapa.get(object);
            if (value != null) {
                builder.append(value.toString());
            }
            if (!iter.hasNext()) continue;
            builder.append(separadorConjunto);
        }
        return builder.toString();
    }
}

