/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class InscricaoEstadual
implements UserType,
Serializable {
    private static final long serialVersionUID = 1L;
    private String value;

    @Deprecated
    public InscricaoEstadual() {
    }

    public InscricaoEstadual(String inscricaoEstadual) {
        if (inscricaoEstadual == null) {
            throw new NullPointerException();
        }
        this.checkPattern(inscricaoEstadual);
        inscricaoEstadual = this.removeSymbols(inscricaoEstadual);
        this.value = inscricaoEstadual.trim().equals("") ? null : inscricaoEstadual;
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("\\d{13}-?\\d{1}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para uma inscri\u00e7\u00e3o estadual v\u00e1lida");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected InscricaoEstadual clone() throws CloneNotSupportedException {
        return new InscricaoEstadual(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InscricaoEstadual)) {
            return false;
        }
        if (this.value == null && ((InscricaoEstadual)obj).value == null) {
            return true;
        }
        if (this.value == null || ((InscricaoEstadual)obj).value == null) {
            return false;
        }
        return this.value.equals(((InscricaoEstadual)obj).value);
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.value)) {
            return "";
        }
        try {
            StringBuilder builder = new StringBuilder(this.value);
            builder.insert(13, '-');
            return builder.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return this.value;
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class returnedClass() {
        return InscricaoEstadual.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value == null) {
            return new InscricaoEstadual();
        }
        return new InscricaoEstadual(value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof InscricaoEstadual) {
            String value2 = ((InscricaoEstadual)value).getValue();
            if (StringUtils.isEmpty((String)value2)) {
                st.setNull(index, 12);
            } else {
                st.setString(index, this.removeSymbols(value2));
            }
        } else {
            st.setNull(index, 12);
        }
    }

    private String removeSymbols(String value2) {
        return value2.replace(".", "").replace("-", "");
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (InscricaoEstadual)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

