/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import br.com.linkcom.neo.util.Util;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Hora
extends Time
implements UserType {
    private static final Log log = LogFactory.getLog(Hora.class);
    private static final long serialVersionUID = -654280595599726647L;

    public Hora() {
        super(0L);
    }

    public Hora(long time) {
        super(time);
    }

    public Hora(String time) {
        super(0L);
        if (time == null) {
            throw new NullPointerException();
        }
        this.checkPattern(time);
        if (time.length() == 3) {
            time = "0" + time;
        }
        this.setTime(Hora.valueOf(String.valueOf(time) + ":00").getTime());
    }

    public String toString() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.getTime());
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        return String.valueOf(hourString) + ":" + minuteString;
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("\\d{1,2}:\\d{2}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para uma hora v\u00e1lida");
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Hora)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x != null) {
            return x.equals(y);
        }
        return x == null && y == null;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Timestamp timestamp;
        block3: {
            try {
                timestamp = rs.getTimestamp(names[0]);
                if (timestamp != null) break block3;
                return null;
            }
            catch (Exception e) {
                String ownerStr = Util.strings.toStringIdStyled(owner);
                String msg = "Uma propriedade do tipo Hora n\u00e3o tem seu campo no banco com o tipo time, timestamp ou date. Objeto: " + ownerStr;
                log.error((Object)msg);
                throw new RuntimeException(msg, e);
            }
        }
        return new Hora(timestamp.getTime());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Hora) {
            st.setTimestamp(index, new Timestamp(((Hora)value).getTime()));
        } else {
            st.setNull(index, 93);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return Hora.class;
    }

    public int[] sqlTypes() {
        return new int[]{93};
    }
}

