/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.report;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRIteratorDataSource
implements JRDataSource {
    private Iterator<?> iterator;
    private Object currentBean;
    protected PropertyNameProvider propertyNameProvider = null;
    protected boolean isUseFieldDescription = true;

    public JRIteratorDataSource(Iterator<?> iterator) {
        this.iterator = iterator;
        this.propertyNameProvider = this.isUseFieldDescription ? new PropertyNameProvider(){

            public String getPropertyName(JRField field) {
                if (field.getDescription() == null) {
                    return field.getName();
                }
                return field.getDescription();
            }
        } : new PropertyNameProvider(){

            public String getPropertyName(JRField field) {
                return field.getName();
            }
        };
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Object value = null;
        if (this.currentBean != null) {
            String propertyName = this.propertyNameProvider.getPropertyName(jrField);
            try {
                value = PropertyUtils.getProperty((Object)this.currentBean, (String)propertyName);
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
            }
        }
        return value;
    }

    static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

