/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.persistence.AliasMap;
import br.com.linkcom.neo.persistence.ObjectTree;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslatorImpl;
import br.com.linkcom.neo.types.Money;
import br.com.linkcom.neo.util.Util;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.usertype.UserType;

class ObjectMapper {
    List<PropertyMapper> mappers = new ArrayList<PropertyMapper>();

    ObjectMapper() {
    }

    void init(AliasMap[] aliasMaps, String[] propriedades) {
        int i = 0;
        while (i < propriedades.length) {
            String full = propriedades[i];
            StringTokenizer stringTokenizer = new StringTokenizer(full, ".");
            String owneralias = stringTokenizer.nextToken();
            String property = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                throw new RuntimeException("n\u00e3o \u00e9 poss\u00edvel ter uma propriedade de propriedade " + full);
            }
            Class owner = QueryBuilderResultTranslatorImpl.getOwner(aliasMaps, owneralias);
            if (owner == null) {
                throw new RuntimeException("N\u00e3o foi encontrado a classe para o alias '" + owneralias + "'");
            }
            Method method = Util.beans.getSetterMethod(owner, property);
            PropertyMapper propertyMapper = new PropertyMapper();
            propertyMapper.index = i++;
            propertyMapper.alias = owneralias;
            if (method == null) {
                throw new RuntimeException("N\u00e3o foi encontrado o m\u00e9todo setter para propriedade '" + property + "' na classe " + owner.getName());
            }
            propertyMapper.setter = method;
            this.mappers.add(propertyMapper);
        }
    }

    void map(Object[] values, ObjectTree objectTree) {
        for (PropertyMapper mapper : this.mappers) {
            mapper.map(values, objectTree);
        }
    }

    class PropertyMapper {
        int index;
        String alias;
        Method setter;

        PropertyMapper() {
        }

        void map(Object[] values, ObjectTree objectTree) {
            Object value = values[this.index];
            boolean instanceofusertype = value instanceof UserType;
            if (!instanceofusertype && value != null || instanceofusertype && ((UserType)value).toString() != null && ((UserType)value).toString().length() > 0) {
                Object object = objectTree.getAliasObject().get(this.alias);
                if (object == null) {
                    if (!(value instanceof Money) || ((Money)value).toLong() != 0L) {
                        throw new RuntimeException("Erro ao configurar propriedade de " + this.alias + " ... " + this.setter + ". O objeto com alias " + this.alias + " n\u00e3o foi criado!! Valor: " + value);
                    }
                } else {
                    try {
                        this.setter.invoke(object, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Erro ao configurar propriedade de " + this.alias + " ... " + this.setter, e);
                    }
                }
            }
        }
    }
}

