/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.bean.annotation.DAOBean;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.persistence.GenericDAO;
import br.com.linkcom.neo.persistence.QueryBuilder;
import br.com.linkcom.neo.util.Util;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DAOBean
public class FileDAO<BEAN extends br.com.linkcom.neo.types.File>
extends GenericDAO<BEAN> {
    public <E extends br.com.linkcom.neo.types.File> E loadWithContents(E bean) {
        br.com.linkcom.neo.types.File arquivo = (br.com.linkcom.neo.types.File)new QueryBuilder(this.getHibernateTemplate()).from(bean.getClass()).entity(bean).unique();
        this.readFile(arquivo);
        return (E)arquivo;
    }

    public void fillWithContents(br.com.linkcom.neo.types.File file) {
        this.readFile(file);
    }

    protected void readFile(br.com.linkcom.neo.types.File arquivo) {
        String nomeArquivo = this.getNomeArquivo(arquivo);
        File file = new File(nomeArquivo);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] bytes = new byte[arquivo.getSize().intValue()];
            bufferedInputStream.read(bytes);
            arquivo.setContent(bytes);
        }
        catch (FileNotFoundException e) {
            throw new NeoException("Arquivo n\u00e3o encontrado. C\u00f3digo: " + arquivo.getCdfile(), e);
        }
        catch (IOException e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel ler o arquivo. ", e);
        }
    }

    protected String getNomeArquivo(br.com.linkcom.neo.types.File arquivo) {
        if (arquivo == null) {
            throw new NullPointerException("Arquivo inv\u00e1lido (nulo)");
        }
        if (arquivo.getCdfile() == null) {
            throw new NullPointerException("Id do arquivo inv\u00e1lido");
        }
        String saveDir = this.getSaveDir();
        return String.valueOf(saveDir) + File.separator + "arquivo" + arquivo.getCdfile() + "." + this.getExtensao();
    }

    protected String getExtensao() {
        return "neo";
    }

    protected String getSaveDir() {
        return String.valueOf(System.getProperty("user.home")) + File.separator + "dados" + File.separator + Neo.getApplicationName() + File.separator + "arquivos";
    }

    public void saveFile(Object bean, String filePropertyName) {
        PropertyDescriptor pd;
        br.com.linkcom.neo.types.File arquivoVelho = null;
        br.com.linkcom.neo.types.File arquivoAtual = null;
        try {
            pd = new PropertyDescriptor(filePropertyName, bean.getClass());
            arquivoAtual = (br.com.linkcom.neo.types.File)pd.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new NeoException("N\u00e3o foi possivel adquirir arquivo. Propriedade " + filePropertyName + " da classe " + bean.getClass(), e);
        }
        if (Util.hibernate.getId(this.getHibernateTemplate(), bean) != null) {
            Object beanVelho = new QueryBuilder(this.getHibernateTemplate()).from(bean.getClass()).leftOuterJoinFetch(String.valueOf(Util.strings.uncaptalize(bean.getClass().getSimpleName())) + "." + filePropertyName + " " + filePropertyName).entity(bean).unique();
            try {
                arquivoVelho = (br.com.linkcom.neo.types.File)pd.getReadMethod().invoke(beanVelho, new Object[0]);
            }
            catch (Exception e) {
                throw new NeoException("N\u00e3o foi possivel adquirir arquivo. Propriedade " + filePropertyName + " da classe " + bean.getClass(), e);
            }
        }
        br.com.linkcom.neo.types.File save = this.save(arquivoAtual, arquivoVelho);
        try {
            pd.getWriteMethod().invoke(bean, save);
        }
        catch (Exception e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel setar o arquivo. Propriedade " + filePropertyName + " da classe " + bean.getClass(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public br.com.linkcom.neo.types.File save(br.com.linkcom.neo.types.File arquivoNovo, br.com.linkcom.neo.types.File arquivoVelho) {
        try {
            if (arquivoVelho == null) {
                if (arquivoNovo == null) return null;
                if (arquivoNovo.getSize() <= 0L) return null;
                this.getHibernateTemplate().saveOrUpdate((Object)arquivoNovo);
                String nomeArquivo = this.getNomeArquivo(arquivoNovo);
                this.writeFile(arquivoNovo, nomeArquivo);
            } else if (arquivoNovo == null) {
                this.getHibernateTemplate().delete((Object)arquivoVelho);
                String nomeArquivo = this.getNomeArquivo(arquivoVelho);
                this.deleteFile(nomeArquivo);
            } else if (arquivoNovo.getSize() > 0L) {
                this.getHibernateTemplate().evict((Object)arquivoVelho);
                arquivoNovo.setCdfile(arquivoVelho.getCdfile());
                this.getHibernateTemplate().saveOrUpdate((Object)arquivoNovo);
                String nomeArquivo = this.getNomeArquivo(arquivoNovo);
                this.writeFile(arquivoNovo, nomeArquivo);
            } else {
                arquivoNovo.setCdfile(arquivoVelho.getCdfile());
            }
            this.getHibernateTemplate().flush();
            return arquivoNovo;
        }
        catch (Exception e) {
            String name;
            try {
                name = this.getNomeArquivo(arquivoNovo);
                throw new NeoException("N\u00e3o foi pos\u00edvel salvar o arquivo. " + name, e);
            }
            catch (Exception e2) {
                name = "(N\u00e3o foi poss\u00edvel adquirir o nome do arquivo. Erro: " + e2.getMessage() + ")";
            }
            throw new NeoException("N\u00e3o foi pos\u00edvel salvar o arquivo. " + name, e);
        }
    }

    protected void deleteFile(String nomeArquivo) {
        File file = new File(nomeArquivo);
        file.delete();
    }

    protected void writeFile(br.com.linkcom.neo.types.File arquivoNovo, String nomeArquivo) throws IOException {
        File file = new File(nomeArquivo);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(arquivoNovo.getContent());
    }
}

