/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.hibernate;

import br.com.linkcom.neo.exception.ConfigurationException;
import br.com.linkcom.neo.hibernate.DefaultEntityFinder;
import br.com.linkcom.neo.hibernate.EntityFinder;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(AnnotationSessionFactoryBean.class);
    private ApplicationContext applicationContext;
    private String dialect;
    protected Class<?>[] annotatedClasses;
    protected EntityFinder entityFinder = new DefaultEntityFinder();

    public void setEntityFinder(EntityFinder entityFinder) {
        this.entityFinder = entityFinder;
    }

    public EntityFinder getEntityFinder() {
        return this.entityFinder;
    }

    public Class<?>[] getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public void setAnnotatedClasses(Class<?>[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass(AnnotationConfiguration.class);
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        AnnotationConfiguration annotationConfiguration = (AnnotationConfiguration)config;
        this.configureAnnotatedBeans(annotationConfiguration);
        return super.newSessionFactory(config);
    }

    public void configureAnnotatedBeans(AnnotationConfiguration annotationConfiguration) {
        int n;
        if (this.entityFinder != null) {
            Class<?>[] classesWithAnnotationEntity;
            if (this.entityFinder instanceof DefaultEntityFinder) {
                ((DefaultEntityFinder)this.entityFinder).setApplicationContext(this.applicationContext);
            }
            try {
                classesWithAnnotationEntity = this.entityFinder.findEntities();
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            Class<?>[] classArray = classesWithAnnotationEntity;
            int n2 = classesWithAnnotationEntity.length;
            n = 0;
            while (n < n2) {
                Class<?> annotatedClass = classArray[n];
                log.debug((Object)("Registrando automaticamente ... " + annotatedClass.getName()));
                annotationConfiguration.addAnnotatedClass(annotatedClass);
                ++n;
            }
        } else {
            log.warn((Object)"EntityFinder n\u00e3o setado");
        }
        if (this.annotatedClasses != null) {
            Class<?>[] classArray = this.annotatedClasses;
            n = this.annotatedClasses.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> annotatedClass = classArray[n3];
                log.debug((Object)("Registrando ... " + annotatedClass.getName()));
                annotationConfiguration.addAnnotatedClass(annotatedClass);
                ++n3;
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        if (hibernateProperties.getProperty("hibernate.show_sql") == null) {
            hibernateProperties.setProperty("hibernate.show_sql", "true");
        }
        this.setDialect(hibernateProperties.getProperty("hibernate.dialect"));
        super.setHibernateProperties(hibernateProperties);
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }
}

