/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.web.init;

import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.classmanager.WebClassRegister;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.init.AnnotationsXmlWebApplicationContext;
import br.com.linkcom.neo.core.web.init.NeoBeanFactoryPostProcessor;
import br.com.linkcom.neo.core.web.init.WebDataSourceConfigStrategy;
import br.com.linkcom.neo.exception.ConfigurationException;
import br.com.linkcom.neo.exception.NeoException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoader
extends org.springframework.web.context.ContextLoader {
    protected static final Log log = LogFactory.getLog(ContextLoader.class);
    protected static final String CONFIG_LOCATION_PARAM = "configLocation";
    protected static final String DEFAULT_CONFIG_LOCATION = "/WEB-INF/applicationConfig.xml";
    protected static final Class NEO_DEFAULT_CONTEXT_CLASS = AnnotationsXmlWebApplicationContext.class;
    protected Config config;

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        String configLocation;
        String contextClassName = servletContext.getInitParameter("contextClass");
        Class<?> contextClass = NEO_DEFAULT_CONTEXT_CLASS;
        if (contextClassName != null) {
            try {
                contextClass = Class.forName(contextClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load context class [" + contextClassName + "]", (Throwable)ex);
            }
            if (!ConfigurableWebApplicationContext.class.isAssignableFrom(contextClass)) {
                throw new ApplicationContextException("Custom context class [" + contextClassName + "] is not of type ConfigurableWebApplicationContext");
            }
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)contextClass);
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        if (AnnotationsXmlWebApplicationContext.class.isAssignableFrom(contextClass)) {
            ((AnnotationsXmlWebApplicationContext)wac).setBeanRegisters(this.config.getBeanRegisters());
            ((AnnotationsXmlWebApplicationContext)wac).setTypeBeanRegisters(this.config.getTypeBeanRegisters());
        }
        if ((configLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray((String)configLocation, (String)",; \t\n"));
        }
        wac.refresh();
        return wac;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ClassManager classManager;
        URL resource;
        AnnotationsXmlWebApplicationContext wac = new AnnotationsXmlWebApplicationContext();
        wac.setServletContext(servletContext);
        String configLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (configLocation == null) {
            configLocation = DEFAULT_CONFIG_LOCATION;
        }
        try {
            resource = servletContext.getResource(configLocation);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Caminho inv\u00e1lido do arquivo de configura\u00e7\u00e3o: " + configLocation, e);
        }
        if (resource != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray((String)configLocation, (String)",; \t\n"));
        }
        try {
            classManager = WebClassRegister.getClassManager(servletContext, "br.com.linkcom.neo");
        }
        catch (IOException e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel inicializar o contexto NEO ", e);
        }
        NeoBeanFactoryPostProcessor neoBeanFactoryPostProcessor = new NeoBeanFactoryPostProcessor(classManager, new WebDataSourceConfigStrategy());
        wac.addBeanFactoryPostProcessor(neoBeanFactoryPostProcessor);
        wac.refresh();
        Map map = wac.getBeansOfType(Config.class);
        Object nomeBean = map.keySet().iterator().next();
        this.config = (Config)map.get(nomeBean);
        log.info((Object)"Criando contexto de aplica\u00e7\u00e3o Neo");
        NeoWeb.createApplicationContext(servletContext, this.config);
        this.config.init();
        return wac;
    }
}

