/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.standard;

import br.com.linkcom.neo.core.standard.DataSourceInfo;
import br.com.linkcom.neo.core.web.init.DataSourceConfigStrategy;
import br.com.linkcom.neo.exception.CouldNotCreateDataSourceException;
import br.com.linkcom.neo.exception.NeoException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jndi.JndiObjectFactoryBean;

class StandardDataSourceConfigStrategy
implements DataSourceConfigStrategy {
    Log log = LogFactory.getLog(StandardDataSourceConfigStrategy.class);
    private DataSourceInfo dataSourceInfo;
    boolean fromResource = false;

    public StandardDataSourceConfigStrategy(DataSourceInfo dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("connection");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (bundle != null) {
            try {
                String driver = bundle.getString("driver");
                String url = bundle.getString("url");
                String username = null;
                String password = null;
                try {
                    username = bundle.getString("username");
                    password = bundle.getString("password");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dataSourceInfo = new DataSourceInfo(driver, url, username, password);
                this.fromResource = true;
            }
            catch (MissingResourceException e) {
                throw new NeoException("Erro ao carregar informa\u00e7\u00f5es de connection.properties. O arquivo est\u00e1 incorreto, faltando algum dos parametros: driver, url");
            }
        }
    }

    public boolean configureDataSource(ConfigurableListableBeanFactory beanFactory) throws CouldNotCreateDataSourceException {
        boolean containsDataSource;
        String dataSourceBeanName = this.getDataSourceBeanName(beanFactory);
        boolean bl = containsDataSource = dataSourceBeanName != null;
        if (this.fromResource) {
            this.log.info((Object)"Criando dataSource com informa\u00e7\u00f5es do arquivo connection.properties");
        } else if (this.dataSourceInfo != null) {
            this.log.info((Object)"Criando dataSource com informa\u00e7\u00f5es fornecidas pelo m\u00e9todo NeoStandard.configureDataSource(..)");
        }
        if (this.dataSourceInfo != null) {
            final DriverManagerDataSource dataSource = new DriverManagerDataSource();
            dataSource.setUrl(this.dataSourceInfo.url);
            dataSource.setDriverClassName(this.dataSourceInfo.driver);
            dataSource.setUsername(this.dataSourceInfo.username);
            dataSource.setPassword(this.dataSourceInfo.password);
            dataSourceBeanName = dataSourceBeanName != null ? dataSourceBeanName : "dataSource";
            FactoryBean factoryBean = new FactoryBean(){

                public Object getObject() throws Exception {
                    return dataSource;
                }

                public Class getObjectType() {
                    return DataSource.class;
                }

                public boolean isSingleton() {
                    return true;
                }
            };
            beanFactory.registerSingleton(dataSourceBeanName, (Object)factoryBean);
            containsDataSource = true;
        }
        return containsDataSource;
    }

    private String getDataSourceBeanName(ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames;
        String[] stringArray = beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        int n = beanDefinitionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanDefinitionName = stringArray[n2];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
            if (beanDefinition instanceof RootBeanDefinition) {
                String beanClassName = ((RootBeanDefinition)beanDefinition).getBeanClassName();
                try {
                    Class<?> forName = Class.forName(beanClassName);
                    if (DataSource.class.isAssignableFrom(forName)) {
                        return beanDefinitionName;
                    }
                    if (FactoryBean.class.isAssignableFrom(forName) && JndiObjectFactoryBean.class.isAssignableFrom(forName) && beanDefinitionName.equals("dataSource")) {
                        return beanDefinitionName;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new NeoException("O bean configurado com o nome " + beanDefinitionName + " est\u00e1 " + "configurado com uma classe inexistente", e);
                }
            }
            ++n2;
        }
        return null;
    }
}

