/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.standard;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.core.standard.ApplicationContext;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.exception.NotInNeoContextException;
import br.com.linkcom.neo.util.Util;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo {
    protected static final InheritableThreadLocal<RequestContext> requestContext = new InheritableThreadLocal();
    protected static final InheritableThreadLocal<ApplicationContext> applicationContext = new InheritableThreadLocal();
    protected static String mensagemErro;

    public static boolean isInApplicationContext() {
        return applicationContext.get() != null;
    }

    public static void setRequestContext(RequestContext context) {
        requestContext.set(context);
        applicationContext.set(context.getApplicationContext());
    }

    public static void setApplicationContext(ApplicationContext context) {
        applicationContext.set(context);
    }

    public static <E> E getObject(Class<E> clazz) {
        return (E)Neo.getApplicationContext().getBean(Util.strings.uncaptalize(clazz.getSimpleName()));
    }

    public static User getUser() {
        return Neo.getRequestContext().getUser();
    }

    public static RequestContext getRequestContext() throws NotInNeoContextException {
        RequestContext neoContext = (RequestContext)requestContext.get();
        if (neoContext == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            throw new NotInNeoContextException("O c\u00f3digo n\u00e3o est\u00e1 sendo excecutado em um contexto NEO! \nClasse: " + stackTrace[3].getClassName() + " " + "\nM\u00e9todo: " + stackTrace[3].getMethodName() + " " + "\nLinha: " + stackTrace[3].getLineNumber() + "\n\nSe voc\u00ea estiver excecutanto em um ambiente J2EE verifique se voc\u00ea configurou no web.xml o filtro da classe " + ", \na configura\u00e7\u00e3o desse filtro \u00e9 importante porque \u00e9 ele que cria o contexto NEO");
        }
        return neoContext;
    }

    public static ApplicationContext getApplicationContext() throws NotInNeoContextException {
        ApplicationContext neoApplicationContext = (ApplicationContext)applicationContext.get();
        if (neoApplicationContext == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            throw new NotInNeoContextException("O c\u00f3digo n\u00e3o est\u00e1 sendo excecutado em um contexto NEO! \nClasse: " + stackTrace[3].getClassName() + " " + "\nM\u00e9todo: " + stackTrace[3].getMethodName() + " " + "\nLinha: " + stackTrace[3].getLineNumber() + "\n\nSe voc\u00ea estiver excecutanto em um ambiente J2EE verifique se voc\u00ea configurou no web.xml o listener da classe br.com.linkcom.neo.core.web.init.ContextLoaderListener e o filtro br.com.linkcom.neo.core.web.NeoFilter. \n" + "Ao criar uma nova Thread o contexto deve ser copiado da Thread inicial!");
        }
        return neoApplicationContext;
    }

    public static String getApplicationName() {
        ApplicationContext applicationContext2 = Neo.getApplicationContext();
        if (applicationContext2 instanceof WebApplicationContext) {
            try {
                URL resource = ((WebApplicationContext)applicationContext2).getServletContext().getResource("/");
                String path = resource.getPath();
                path = path.substring(0, path.lastIndexOf(47));
                path = path.substring(path.lastIndexOf(47) + 1);
                return path;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }
}

