/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller;

import br.com.linkcom.neo.bean.annotation.DisplayName;
import br.com.linkcom.neo.bean.annotation.Ref;
import br.com.linkcom.neo.controller.Command;
import br.com.linkcom.neo.controller.Input;
import br.com.linkcom.neo.controller.MethodNameResolverImpl;
import br.com.linkcom.neo.controller.OnErrors;
import br.com.linkcom.neo.controller.ServletRequestDataBinderNeo;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.validation.ObjectAnnotationValidator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiActionController
extends AbstractController {
    public static final String CLEAR_FILTER = "clearFilter";
    public static final String SUPPRESS_ERRORS = "suppressErrors";
    private static final String SUPPRESS_VALIDATION = "suppressValidation";
    public static final String ACTION_PARAMETER = "ACAO";
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private MethodNameResolverImpl methodNameResolver;
    private Validator[] validators;
    private Object delegate;
    private Map<String, Method> handlerMethodMap;
    private Map<Class<Throwable>, Method> exceptionHandlerMap;

    public MultiActionController() throws ApplicationContextException {
        this.setDelegate((Object)this);
    }

    public MultiActionController(Object delegate) throws ApplicationContextException {
        this.setDelegate(delegate);
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    @Ref(bean="<null>")
    public final void setDelegate(Object delegate) throws ApplicationContextException {
        if (delegate == null) {
            return;
        }
        this.delegate = delegate;
        this.methodNameResolver = new MethodNameResolverImpl((Object)this);
        this.exceptionHandlerMap = new HashMap<Class<Throwable>, Method>();
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            WebRequestContext requestContext = NeoWeb.getRequestContext(request, response);
            Method method = this.methodNameResolver.getHandlerMethod(request);
            request.setAttribute("firstAction", (Object)requestContext.getLastAction());
            ModelAndView result = this.invokeNamedMethod(method, requestContext, null);
            while (result != null && result.getViewName() != null && result.getViewName().startsWith("action:")) {
                String actionName = result.getViewName().substring("action:".length(), result.getViewName().length());
                method = this.methodNameResolver.getHandlerMethod(actionName);
                result = this.invokeNamedMethod(method, requestContext, null);
            }
            request.setAttribute("lastAction", (Object)requestContext.getLastAction());
            return result;
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            String parameter = request.getParameter(ACTION_PARAMETER);
            pageNotFoundLogger.warn((Object)(String.valueOf(ex.getMessage()) + ", ACAO=" + parameter + ". " + "Checar se o m\u00e9todo possui uma assinatura no seguinte padr\u00e3o: public <nome do m\u00e9todo>(WebRequestContext request, <Classe do Command> <nome do command>). " + "O m\u00e9todo pode opcionalmente lan\u00e7ar exce\u00e7\u00f5es. A classe do command pode ser qualquer uma."));
            if (parameter == null) {
                pageNotFoundLogger.warn((Object)"Verifique se algum m\u00e9todo do controller possui a anota\u00e7\u00e3o @DefaultAction");
            }
            response.sendError(404, String.valueOf(ex.getMessage()) + ".\n Verifique o log para mais informa\u00e7\u00f5es");
            return null;
        }
    }

    protected ModelAndView goToAction(String action) {
        ((DefaultWebRequestContext)NeoWeb.getRequestContext()).setLastAction(action);
        return new ModelAndView("action:" + action);
    }

    protected ModelAndView continueOnAction(String action, Object command) {
        WebRequestContext request = NeoWeb.getRequestContext();
        ((DefaultWebRequestContext)request).setLastAction(action);
        HttpServletResponse servletResponse = request.getServletResponse();
        try {
            Method method = this.methodNameResolver.getHandlerMethod(action);
            ModelAndView result = this.invokeNamedMethod(method, NeoWeb.getRequestContext(request.getServletRequest(), servletResponse), command);
            request.setAttribute("firstAction", request.getLastAction());
            while (result != null && result.getViewName() != null && result.getViewName().startsWith("action:")) {
                String actionName = result.getViewName().substring("action:".length(), result.getViewName().length());
                method = this.methodNameResolver.getHandlerMethod(actionName);
                result = this.invokeNamedMethod(method, request, command);
            }
            request.setAttribute("lastAction", request.getLastAction());
            return result;
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            pageNotFoundLogger.warn((Object)ex.getMessage());
            try {
                servletResponse.sendError(404);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ModelAndView sendRedirectToAction(String action) {
        WebRequestContext requestContext = NeoWeb.getRequestContext();
        String requestQuery = requestContext.getRequestQuery();
        String query = "?ACAO=" + action;
        return new ModelAndView("redirect:" + requestQuery + (action == null ? "" : query));
    }

    /*
     * Loose catch block
     */
    protected final ModelAndView invokeNamedMethod(Method method, WebRequestContext request, Object useCommand) throws Exception {
        while (true) {
            Input input = null;
            boolean fromErrors = false;
            try {
                ArrayList<Object> params = new ArrayList<Object>(2);
                params.add(request);
                if (useCommand == null) {
                    if (method.getParameterTypes().length == 2) {
                        ServletRequestDataBinder binder;
                        Object command;
                        Class<?> commandClass = this.getCommandClass(method);
                        CommandInfo commandInfo = this.getCommandInfo(method);
                        input = this.getAnnotation(method, Input.class);
                        if (!fromErrors) {
                            command = this.getCommandObject(request, commandClass, commandInfo);
                            binder = this.bind(request, command, commandInfo.validate);
                        } else {
                            command = this.getCommandObject(request, commandClass, commandInfo);
                            binder = new ServletRequestDataBinder(command, this.getCommandName(command));
                        }
                        params.add(command);
                        if (binder.getErrors().hasErrors()) {
                            if (input != null) {
                                String inputAction = input.value();
                                ((DefaultWebRequestContext)request).setLastAction(inputAction);
                                Method handlerMethod = this.methodNameResolver.getHandlerMethod(inputAction);
                                ((DefaultWebRequestContext)request).setBindException(binder.getErrors());
                                if (!handlerMethod.getName().equals(method.getName())) {
                                    ((DefaultWebRequestContext)request).setBindException(binder.getErrors());
                                    method = handlerMethod;
                                }
                            } else {
                                binder.closeNoCatch();
                            }
                        }
                    }
                } else {
                    params.add(useCommand);
                }
                return (ModelAndView)method.invoke(this.delegate, params.toArray(new Object[params.size()]));
            }
            catch (NoSuchRequestHandlingMethodException e) {
                throw e;
            }
            catch (NeoException e) {
                throw e;
            }
            catch (InvocationTargetException ex) {
                if (input == null) {
                    OnErrors onErrors = this.getAnnotation(method, OnErrors.class);
                    if (onErrors != null) {
                        fromErrors = true;
                        ((DefaultWebRequestContext)request).setLastAction(onErrors.value());
                        Method methodErrors = this.methodNameResolver.getHandlerMethod(onErrors.value());
                        request.addError(ex.getTargetException());
                        this.logger.error((Object)("Erro ao invocar m\u00e9todo " + method.getName() + " da classe " + ((Object)((Object)this)).getClass().getName() + ". Redirecionando para onErrors: " + onErrors.value()), ex.getTargetException());
                        method = methodErrors;
                        continue;
                    }
                } else {
                    boolean sameMethod = false;
                    String inputName = input.value();
                    Method handlerMethod = this.methodNameResolver.getHandlerMethod(inputName);
                    sameMethod = handlerMethod.getName().equals(method.getName());
                    if (!sameMethod) {
                        method = handlerMethod;
                        request.addError(ex.getTargetException());
                        ((DefaultWebRequestContext)request).setLastAction(inputName);
                        this.logger.error((Object)("Erro ao invocar m\u00e9todo " + method.getName() + " da classe " + ((Object)((Object)this)).getClass().getName() + ". Redirecionando para input: " + inputName), ex.getTargetException());
                        continue;
                    }
                }
                return this.handleException(request, ex.getTargetException());
            }
            catch (IllegalArgumentException ex) {
                throw new NeoException("N\u00e3o foi poss\u00edvel invocar o m\u00e9todo. Se estiver utilizando o m\u00e9todo continueToAction verifique se o m\u00e9todo que pede o redirecionamento e o m\u00e9todo de destino possuem a mesma classe de command", ex);
            }
            break;
        }
        catch (Exception ex) {
            return this.handleException(request, ex);
        }
    }

    private CommandInfo getCommandInfo(Method method) {
        CommandInfo commandInfo = new CommandInfo();
        Command commandInfoAnnotation = this.getAnnotation(method, Command.class);
        if (commandInfoAnnotation == null) {
            return commandInfo;
        }
        commandInfo.name = commandInfoAnnotation.name();
        commandInfo.session = commandInfoAnnotation.session();
        commandInfo.validate = commandInfoAnnotation.validate();
        return commandInfo;
    }

    private Method firstMethod(Class ofClass, Method expectedMethod) {
        Method[] methods;
        if (ofClass.equals(expectedMethod.getDeclaringClass())) {
            return expectedMethod;
        }
        Method[] methodArray = methods = ofClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(expectedMethod.getName()) && Arrays.deepEquals(method.getParameterTypes(), expectedMethod.getParameterTypes())) {
                return method;
            }
            ++n2;
        }
        return this.firstMethod(ofClass.getSuperclass(), expectedMethod);
    }

    private <A extends Annotation> A getAnnotation(Method method, Class<A> annotation) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        A result = null;
        if (reflectionCache.isAnnotationPresent(method, annotation)) {
            result = method.getAnnotation(annotation);
        } else {
            Method superMethod = this.getSuperClassMethod(method);
            if (superMethod != null) {
                result = this.getAnnotation(superMethod, annotation);
            }
        }
        return result;
    }

    private Method getSuperClassMethod(Method method) {
        Class<?> superclass = method.getDeclaringClass().getSuperclass();
        Method superMethod = null;
        if (!MultiActionController.class.equals(superclass)) {
            Method[] methods;
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            Method[] methodArray = methods = reflectionCache.getMethods(superclass);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method2 = methodArray[n2];
                if (method2.getName().equals(method.getName())) {
                    superMethod = method2;
                    break;
                }
                ++n2;
            }
        }
        return superMethod;
    }

    protected Class<?> getCommandClass(Method method) {
        Class commandClass = null;
        Method metodoOriginal = method;
        do {
            Type[] genericParameterTypes;
            Type type;
            if ((type = (genericParameterTypes = method.getGenericParameterTypes())[1]) instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                String typeVariableName = typeVariable.getName();
                TypeVariable<Class<?>>[] typeParameters = ((Object)((Object)this)).getClass().getTypeParameters();
                if (typeParameters.length != 0) {
                    throw new NeoException("Implementar achar tipo de command por genericTypeParameters");
                }
                Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
                if (!(genericSuperclass instanceof ParameterizedType)) break;
                TypeVariable<Class<?>>[] typeParametersMethodClass = method.getDeclaringClass().getTypeParameters();
                int i = 0;
                TypeVariable<Class<?>>[] typeVariableArray = typeParametersMethodClass;
                int n = typeParametersMethodClass.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeVariable<Class<?>> variable = typeVariableArray[n2];
                    if (variable.getName().equals(typeVariableName)) {
                        commandClass = (Class)((ParameterizedType)genericSuperclass).getActualTypeArguments()[i];
                    }
                    ++i;
                    ++n2;
                }
                break;
            }
            if (!(type instanceof Object)) continue;
            method = this.getSuperClassMethod(method);
        } while (commandClass == null && method != null);
        if (commandClass == null) {
            commandClass = metodoOriginal.getParameterTypes()[metodoOriginal.getParameterTypes().length - 1];
        }
        return commandClass;
    }

    protected <E> E getCommandObject(WebRequestContext request, Class<E> clazz, CommandInfo commandInfo) throws Exception {
        E command;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Must create new command of class [" + clazz.getName() + "]"));
        }
        boolean session = commandInfo.session;
        String name = commandInfo.name;
        if (session) {
            E sessionCommand;
            if (Util.strings.isEmpty(name)) {
                name = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "CONTROLLER" + clazz.getName();
            }
            command = sessionCommand = this.getSessionCommand(request, clazz, name);
        } else {
            E command2;
            command = command2 = this.getCommand(request, clazz, name);
        }
        return command;
    }

    private <E> E getCommand(WebRequestContext request, Class<E> clazz, String name) throws Exception {
        return (E)BeanUtils.instantiateClass(clazz);
    }

    protected <E> E getSessionCommand(WebRequestContext request, Class<E> clazz, String name) {
        Object sessionCommand = request.getSession().getAttribute(name);
        if (sessionCommand == null || "true".equalsIgnoreCase(request.getParameter(CLEAR_FILTER))) {
            sessionCommand = BeanUtils.instantiateClass(clazz);
            request.getSession().setAttribute(name, sessionCommand);
        }
        return (E)sessionCommand;
    }

    protected ServletRequestDataBinder bind(WebRequestContext request, Object command, boolean validate) throws Exception {
        this.logger.debug((Object)"Binding request parameters onto MultiActionController command");
        ServletRequestDataBinder binder = this.createBinder((ServletRequest)request.getServletRequest(), command, this.getCommandName(command));
        if (command.getClass().equals(Object.class)) {
            return binder;
        }
        binder.bind((ServletRequest)request.getServletRequest());
        if (validate) {
            this.validate(request, command, binder);
        }
        String acao = request.getParameter(ACTION_PARAMETER);
        this.customValidation(request, command, binder.getErrors(), acao);
        return binder;
    }

    protected void customValidation(WebRequestContext request, Object command, BindException errors, String acao) {
    }

    protected void validate(WebRequestContext request, Object command, ServletRequestDataBinder binder) {
        if (!this.suppressValidation(request, command)) {
            BindException errors = binder.getErrors();
            if (request.getAttribute("MAXUPLOADEXCEEDED") != null) {
                errors.reject("", "O tamanho m\u00e1ximo de upload de arquivos (10M) foi excedido");
            }
            ObjectAnnotationValidator objectAnnotationValidator = new ObjectAnnotationValidator(request);
            objectAnnotationValidator.validate(command, (Errors)errors);
            String acao = request.getParameter(ACTION_PARAMETER);
            this.validate(command, errors, acao);
            if (this.validators != null) {
                int i = 0;
                while (i < this.validators.length) {
                    if (this.validators[i].supports(command.getClass())) {
                        ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)command, (Errors)errors);
                    }
                    ++i;
                }
            }
        }
    }

    protected void validate(Object obj, BindException errors, String acao) {
    }

    protected boolean suppressValidation(WebRequestContext request, Object command) {
        String suppress = request.getParameter(SUPPRESS_VALIDATION);
        return "true".equalsIgnoreCase(suppress);
    }

    protected ServletRequestDataBinder createBinder(ServletRequest request, Object command, String commandDisplayName) throws Exception {
        ServletRequestDataBinderNeo binder = new ServletRequestDataBinderNeo(command, commandDisplayName);
        this.initBinder(request, binder);
        return binder;
    }

    protected String getCommandName(Object command) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        DisplayName displayName = reflectionCache.getAnnotation(command.getClass(), DisplayName.class);
        return displayName != null ? displayName.value() : command.getClass().getSimpleName();
    }

    protected void initBinder(ServletRequest request, ServletRequestDataBinder binder) throws Exception {
    }

    protected Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Trying to find handler for exception class [" + exceptionClass.getName() + "]"));
        }
        Method handler = this.exceptionHandlerMap.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(Throwable.class)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to find handler for exception superclass [" + exceptionClass.getName() + "]"));
            }
            exceptionClass = exceptionClass.getSuperclass();
            handler = this.exceptionHandlerMap.get(exceptionClass);
        }
        return handler;
    }

    private ModelAndView handleException(WebRequestContext request, Throwable ex) throws Exception {
        Method handler = this.getExceptionHandler(ex);
        if (handler != null) {
            return this.invokeExceptionHandler(handler, request, ex);
        }
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new ServletException("Unknown Throwable type encountered: " + ex);
    }

    private ModelAndView invokeExceptionHandler(Method handler, WebRequestContext request, Throwable ex) throws Exception {
        if (handler == null) {
            throw new ServletException("No handler for exception", ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking exception handler [" + handler + "] for exception [" + ex + "]"));
        }
        try {
            ModelAndView mv = (ModelAndView)handler.invoke(this.delegate, request, ex);
            while (mv != null && mv.getViewName() != null && mv.getViewName().startsWith("action:")) {
                String actionName = mv.getViewName().substring("action:".length(), mv.getViewName().length());
                Method method = this.methodNameResolver.getHandlerMethod(actionName);
                mv = this.invokeNamedMethod(method, request, null);
            }
            return mv;
        }
        catch (InvocationTargetException ex2) {
            Throwable targetEx = ex2.getTargetException();
            if (targetEx instanceof Exception) {
                throw (Exception)targetEx;
            }
            if (targetEx instanceof Error) {
                throw (Error)targetEx;
            }
            throw new ServletException("Unknown Throwable type encountered", targetEx);
        }
    }

    public Map<String, Method> getHandlerMethodMap() {
        return this.handlerMethodMap;
    }

    public static class CommandInfo {
        protected String name = "";
        protected boolean validate = false;
        protected boolean session = false;

        public String toString() {
            return "name: " + this.name + ", validate: " + this.validate + ", session: " + this.session;
        }
    }
}

