/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import java.beans.PropertyEditorSupport;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimePropertyEditor
extends PropertyEditorSupport {
    private String pattern = "HH:mm";
    private DateFormat dateFormat = new SimpleDateFormat(this.pattern);
    private boolean lenient = false;

    public TimePropertyEditor() {
    }

    public TimePropertyEditor(String pattern) {
        this.pattern = pattern;
        this.dateFormat = new SimpleDateFormat(this.pattern);
    }

    public TimePropertyEditor(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null && !text.trim().equals("")) {
            try {
                this.dateFormat.setLenient(this.lenient);
                Time time = new Time(this.dateFormat.parse(text).getTime());
                this.setValue(time);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return this.dateFormat.format((Time)this.getValue());
    }

    public Object getValue() {
        Object object = super.getValue();
        if (object instanceof Date) {
            Time timestamp = new Time(((Date)object).getTime());
            return timestamp;
        }
        return object;
    }
}

