/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import br.com.linkcom.neo.types.File;
import java.io.IOException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.web.multipart.MultipartFile;

public class FileEditor
extends ByteArrayPropertyEditor {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void setValue(Object value) {
        if (value instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value;
            long size = multipartFile.getSize();
            try {
                File file = this.createFile(value);
                String name = multipartFile.getOriginalFilename();
                name = name.replace('\\', '/');
                if (name.contains("/")) {
                    name = name.substring(name.indexOf(47));
                }
                file.setName(name);
                file.setContenttype(multipartFile.getContentType());
                file.setContent(multipartFile.getBytes());
                file.setSize(size);
                file.setTsmodification(new Timestamp(System.currentTimeMillis()));
                super.setValue((Object)file);
            }
            catch (IOException ex) {
                this.logger.error((Object)"Cannot read contents of multipart file", (Throwable)ex);
                throw new IllegalArgumentException("Cannot read contents of multipart file: " + ex.getMessage());
            }
        }
    }

    protected File createFile(Object value) {
        throw new IllegalArgumentException("\n\nPara utilizar o editor de arquivos, voc\u00ea deve extender a classe br.com.linkcom.neo.spring.beans.editors.FileEditor e sobrescrever o m\u00e9todo createFile.\nO createFile sobrescrito deve criar um File espec\u00edfico da aplicacao.\nVoc\u00ea deve registrar o editor criado, sobrescrevendo o m\u00e9todo initBinder nos Controllers se quiser utilizar uploads de arquivos.\nO m\u00e9todo initBinder recebe um argumento binder que possui um m\u00e9todo para registrar conversores (registerCustomEditor)");
    }

    public String getAsText() {
        byte[] value = (byte[])this.getValue();
        return value != null ? new String(value) : "";
    }
}

