/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class CustomSqlDateEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;

    public CustomSqlDateEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            try {
                this.setValue(new java.sql.Date(this.dateFormat.parse(text).getTime()));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse date: " + ex.getMessage());
            }
        }
    }

    public String getAsText() {
        return this.getValue() == null ? "" : this.dateFormat.format((Date)this.getValue());
    }

    public Object getValue() {
        Object object = super.getValue();
        if (!(object instanceof java.sql.Date) && object instanceof Date) {
            return new java.sql.Date(((Date)object).getTime());
        }
        return object;
    }
}

