/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

final class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog(CachedIntrospectionResults.class);
    private static final Map classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map propertyDescriptorCache;

    static CachedIntrospectionResults forClass(Class clazz) throws BeansException {
        CachedIntrospectionResults results = null;
        Object value = classCache.get(clazz);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            results = new CachedIntrospectionResults(clazz);
            boolean cacheSafe = CachedIntrospectionResults.isCacheSafe(clazz);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Class [" + clazz.getName() + "] is " + (!cacheSafe ? "not " : "") + "cache-safe"));
            }
            if (cacheSafe) {
                classCache.put(clazz, results);
            } else {
                classCache.put(clazz, new WeakReference<CachedIntrospectionResults>(results));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached introspection results for class [" + clazz.getName() + "]"));
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isCacheSafe(Class clazz) {
        cur = CachedIntrospectionResults.class.getClassLoader();
        target = clazz.getClassLoader();
        if (target != null && cur != target) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if ((cur = cur.getParent()) != target) continue;
            return true;
lbl7:
            // 2 sources

            ** while (cur != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    private CachedIntrospectionResults(Class clazz) throws BeansException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting BeanInfo for class [" + clazz.getName() + "]"));
            }
            this.beanInfo = Introspector.getBeanInfo(clazz);
            Class classToFlush = clazz;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching PropertyDescriptors for class [" + clazz.getName() + "]"));
            }
            this.propertyDescriptorCache = new HashMap();
            PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                Method writeMethod;
                Method readMethod;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found property '" + pds[i].getName() + "'" + (pds[i].getPropertyType() != null ? " of type [" + pds[i].getPropertyType().getName() + "]" : "") + (pds[i].getPropertyEditorClass() != null ? "; editor [" + pds[i].getPropertyEditorClass().getName() + "]" : "")));
                }
                if ((readMethod = pds[i].getReadMethod()) != null && !Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((writeMethod = pds[i].getWriteMethod()) != null && !Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                this.propertyDescriptorCache.put(pds[i].getName(), pds[i]);
                ++i;
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + clazz.getName() + "]", (Throwable)ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorCache.get(propertyName);
    }
}

