/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.DisplayNameUtil;
import br.com.linkcom.neo.bean.IndexValueResolver;
import br.com.linkcom.neo.bean.IndexValueResolverImpl;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.bean.PropertyDescriptorBeanWrapper;
import br.com.linkcom.neo.bean.PropertyDescriptorImpl;
import br.com.linkcom.neo.bean.annotation.DescriptionProperty;
import br.com.linkcom.neo.exception.BeanDescriptorCreationException;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import java.lang.reflect.Method;
import javax.persistence.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDescriptorImpl<E>
implements BeanDescriptor<E> {
    private E bean;
    private Class<E> clazz;
    private String descriptionPropertyName;
    private String idPropertyName;
    private String displayName;
    private PropertyDescriptorBeanWrapper beanWrapper;

    public PropertyDescriptorBeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public BeanDescriptorImpl(E bean, Class<E> clazz) throws NullPointerException, IllegalArgumentException {
        if (bean == null && clazz == null) {
            throw new BeanDescriptorCreationException("Erro ao criar BeanDescriptor. O objeto \u00e9 nulo e a classe n\u00e3o foi informada");
        }
        this.bean = bean;
        if (clazz != null && bean != null && !clazz.isAssignableFrom(bean.getClass())) {
            throw new IllegalArgumentException("Erro ao criar BeanDescriptor. O objeto passado n\u00e3o \u00e9 do tipo da classe informada");
        }
        Class<Object> clazz2 = this.clazz = clazz == null ? bean.getClass() : clazz;
        if (this.clazz.getName().contains("$$")) {
            Class<E> superclass = this.clazz.getSuperclass();
            this.clazz = superclass;
        }
        this.beanWrapper = new PropertyDescriptorBeanWrapper(this.clazz, bean);
        this.beanWrapper.setIndexValueResolver(new IndexValueResolverImpl());
    }

    @Override
    public String getDescriptionPropertyName() {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        if (this.descriptionPropertyName == null) {
            Class<E> clazz = this.clazz;
            while (!clazz.equals(Object.class) && this.descriptionPropertyName == null) {
                Method[] methods;
                Method[] methodArray = methods = reflectionCache.getMethods(clazz);
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (reflectionCache.isAnnotationPresent(method, DescriptionProperty.class)) {
                        if (this.descriptionPropertyName != null) {
                            throw new NeoException("A classe " + clazz + " declarou 2 @DescriptionProperty");
                        }
                        this.descriptionPropertyName = Util.beans.getPropertyFromGetter(method.getName());
                    }
                    ++n2;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return this.descriptionPropertyName;
    }

    @Override
    public String getIdPropertyName() {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        if (this.idPropertyName == null) {
            Class<E> clazz = this.clazz;
            while (!clazz.equals(Object.class) && this.idPropertyName == null) {
                Method[] methods;
                Method[] methodArray = methods = reflectionCache.getMethods(clazz);
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (reflectionCache.isAnnotationPresent(method, Id.class)) {
                        if (this.idPropertyName != null) {
                            throw new NeoException("A classe " + clazz + " declarou 2 @Id");
                        }
                        this.idPropertyName = Util.beans.getPropertyFromGetter(method.getName());
                    }
                    ++n2;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return this.idPropertyName;
    }

    @Override
    public Object getDescription() {
        if (this.getDescriptionPropertyName() != null) {
            return this.getPropertyDescriptor(this.getDescriptionPropertyName()).getValue();
        }
        return null;
    }

    @Override
    public Object getId() {
        if (this.getIdPropertyName() != null) {
            return this.getPropertyDescriptor(this.getIdPropertyName()).getValue();
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = DisplayNameUtil.getDisplayName(this.clazz);
        }
        return this.displayName;
    }

    @Override
    public E getTargetBean() {
        return this.bean;
    }

    @Override
    public Class<E> getTargetClass() {
        return this.clazz;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return new PropertyDescriptorImpl(this, propertyName);
    }

    @Override
    public void setIndexValueResolver(IndexValueResolver indexValueResolver) {
        this.beanWrapper.setIndexValueResolver(indexValueResolver);
    }
}

