/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.process;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModuleSupport;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.process.ProcessAuthorization;
import br.com.linkcom.neo.authorization.process.ProcessAuthorizer;
import br.com.linkcom.neo.exception.InconsistencyException;

public class ProcessAuthorizationModule
extends AuthorizationModuleSupport {
    public static final String PROCESSOS = "Processos";
    protected static final String EXECUTE = "execute";

    public ProcessAuthorization createAuthorization(Permission[] permissoes) {
        boolean canGenerate = false;
        Permission[] permissionArray = permissoes;
        int n = permissoes.length;
        int n2 = 0;
        while (n2 < n) {
            Permission permission = permissionArray[n2];
            try {
                if (canGenerate) break;
                canGenerate = permission.getPermissionvalue(EXECUTE).equals("true");
            }
            catch (Exception e) {
                throw new InconsistencyException("Inconsistencia no objeto Permission! Faltando parametro (execute): " + permission);
            }
            ++n2;
        }
        ProcessAuthorization authorization = new ProcessAuthorization();
        authorization.setCanExecute(canGenerate);
        return authorization;
    }

    public boolean isAuthorized(String acao, Authorization autorizacao) {
        return ProcessAuthorizer.getInstance().isAuthorized(acao, autorizacao);
    }

    public AuthorizationItem[] getAuthorizationItens() {
        return new AuthorizationItem[]{new AuthorizationItem(EXECUTE, "executar", new String[]{"true", "false"})};
    }

    public String getAuthorizationGroupName() {
        return PROCESSOS;
    }
}

