/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.impl;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionPK;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.authorization.impl.PermissionImpl;
import br.com.linkcom.neo.exception.AuthorizationException;
import br.com.linkcom.neo.exception.ConfigurationException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationDAOHibernate
implements AuthorizationDAO {
    static Log log = LogFactory.getLog(AuthorizationDAOHibernate.class);
    protected String userQuery;
    protected String rolesQuery;
    protected String permissionQuery;
    protected HibernateTemplate hibernateTemplate;

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public String getPermissionQuery() {
        return this.permissionQuery;
    }

    public String getRolesQuery() {
        return this.rolesQuery;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public void setPermissionQuery(String permissionQuery) {
        this.permissionQuery = permissionQuery;
    }

    public void setRolesQuery(String rolesQuery) {
        this.rolesQuery = rolesQuery;
    }

    public void setUserQuery(String userQuery) {
        this.userQuery = userQuery;
    }

    @Override
    public User findUserByLogin(String login) {
        if (this.userQuery == null) {
            throw new ConfigurationException("Propriedade userQuery n\u00e3o fornecida");
        }
        try {
            List find = this.hibernateTemplate.find(this.userQuery, (Object)login);
            return find.size() == 0 ? null : (User)find.get(0);
        }
        catch (Exception e) {
            throw new AuthorizationException("Problema ao excecutar query na classe " + AuthorizationDAOHibernate.class.getName() + ". Query: " + this.userQuery, e);
        }
    }

    @Override
    public Role[] findUserRoles(User user) {
        if (this.rolesQuery == null) {
            throw new ConfigurationException("Propriedade userQuery n\u00e3o fornecida");
        }
        try {
            List find = this.hibernateTemplate.find(this.rolesQuery, (Object)user);
            return find.toArray(new Role[find.size()]);
        }
        catch (Exception e) {
            throw new AuthorizationException("Problema ao excecutar query na classe " + AuthorizationDAOHibernate.class.getName() + ". Query: " + this.rolesQuery);
        }
    }

    @Override
    public Permission findPermission(Role role, String controlName) {
        if (this.permissionQuery == null) {
            throw new ConfigurationException("Propriedade userQuery n\u00e3o fornecida");
        }
        try {
            List find = this.hibernateTemplate.find(this.permissionQuery, new Object[]{role, controlName});
            return find.size() == 0 ? null : (Permission)find.get(0);
        }
        catch (Exception e) {
            throw new AuthorizationException("Problema ao excecutar query na classe " + AuthorizationDAOHibernate.class.getName() + ". Query: " + this.permissionQuery);
        }
    }

    @Override
    public Permission savePermission(String controlName, Role role, Map<String, String> permissionMap) {
        log.debug((Object)("savePermission controlName=" + controlName + ", role=" + role.getName() + ", permissionMap=" + permissionMap));
        PermissionImpl permissionImpl = new PermissionImpl();
        PermissionPK permissionPK = new PermissionPK();
        permissionImpl.setPermissionPK(permissionPK);
        permissionPK.setControlName(controlName);
        permissionPK.setRole(role);
        permissionImpl.setPermissionMap(permissionMap);
        return permissionImpl;
    }

    @Override
    public Role[] findAllRoles() {
        try {
            List find = this.hibernateTemplate.find("from " + Role.class.getName());
            Role[] toArray = find.toArray(new Role[find.size()]);
            return toArray;
        }
        catch (Exception e) {
            throw new AuthorizationException("Problema ao excecutar query na classe " + AuthorizationDAOHibernate.class.getName() + ". Query: from " + Role.class.getName());
        }
    }
}

