/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.crud;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModuleSupport;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.crud.CrudAuthorization;
import br.com.linkcom.neo.authorization.crud.CrudAuthorizer;
import br.com.linkcom.neo.exception.InconsistencyException;

public class CrudAuthorizationModule
extends AuthorizationModuleSupport {
    public static final String LISTAGENS_ENTRADA_DE_DADOS = "Listagens / Entrada de dados";
    protected static final String READ = "read";
    protected static final String CREATE = "create";
    protected static final String UPDATE = "update";
    protected static final String DELETE = "delete";

    public CrudAuthorization createAuthorization(Permission[] permissoes) {
        boolean canCreate = false;
        boolean canRead = false;
        boolean canUpdate = false;
        boolean canDelete = false;
        int i = 0;
        while (i < permissoes.length) {
            Permission permissao = permissoes[i];
            try {
                String permissionvalue;
                if (permissao == null) {
                    throw new NullPointerException("permissao nula encontrada");
                }
                if (!canCreate) {
                    permissionvalue = permissao.getPermissionvalue(CREATE);
                    if (permissionvalue == null) {
                        throw new IllegalArgumentException("Sem par\u00e2metro: create");
                    }
                    canCreate = permissionvalue.equals("true");
                }
                if (!canRead) {
                    permissionvalue = permissao.getPermissionvalue(READ);
                    if (permissionvalue == null) {
                        throw new IllegalArgumentException("Sem par\u00e2metro: read");
                    }
                    canRead = permissionvalue.equals("true");
                }
                if (!canUpdate) {
                    permissionvalue = permissao.getPermissionvalue(UPDATE);
                    if (permissionvalue == null) {
                        throw new IllegalArgumentException("Sem par\u00e2metro: update");
                    }
                    canUpdate = permissionvalue.equals("true");
                }
                if (!canDelete) {
                    permissionvalue = permissao.getPermissionvalue(DELETE);
                    if (permissionvalue == null) {
                        throw new IllegalArgumentException("Sem par\u00e2metro: delete");
                    }
                    canDelete = permissionvalue.equals("true");
                }
            }
            catch (IllegalArgumentException e) {
                throw new InconsistencyException("Inconsistencia no objeto Permission! Faltando algum dos parametros (create, read, update ou delete): " + permissao + "..." + e.getMessage());
            }
            catch (NullPointerException e) {
                throw new InconsistencyException("NullPointerException inespereado no CRUDAuthorizationModule " + e.getMessage());
            }
            ++i;
        }
        CrudAuthorization autorizacao = new CrudAuthorization();
        autorizacao.setCreate(canCreate);
        autorizacao.setRead(canRead);
        autorizacao.setUpdate(canUpdate);
        autorizacao.setDelete(canDelete);
        return autorizacao;
    }

    public boolean isAuthorized(String acao, Authorization autorizacao) {
        return CrudAuthorizer.getInstance().isAuthorized(acao, autorizacao);
    }

    public AuthorizationItem[] getAuthorizationItens() {
        return new AuthorizationItem[]{new AuthorizationItem(READ, "ler", new String[]{"true", "false"}), new AuthorizationItem(CREATE, "criar", new String[]{"true", "false"}), new AuthorizationItem(UPDATE, "editar", new String[]{"true", "false"}), new AuthorizationItem(DELETE, "excluir", new String[]{"true", "false"})};
    }

    public String getAuthorizationGroupName() {
        return LISTAGENS_ENTRADA_DE_DADOS;
    }
}

