/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.authorization.AuthorizationProcessFilter;
import br.com.linkcom.neo.authorization.AuthorizationProcessItemFilter;
import br.com.linkcom.neo.authorization.HasAccessAuthorizationModule;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.PermissionLocator;
import br.com.linkcom.neo.authorization.Role;
import br.com.linkcom.neo.controller.Action;
import br.com.linkcom.neo.controller.ControlMapping;
import br.com.linkcom.neo.controller.ControlMappingLocator;
import br.com.linkcom.neo.controller.Controller;
import br.com.linkcom.neo.controller.DefaultAction;
import br.com.linkcom.neo.controller.Input;
import br.com.linkcom.neo.controller.MultiActionController;
import br.com.linkcom.neo.core.standard.ApplicationContext;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.view.menu.MenuTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationProcess
extends MultiActionController {
    AuthorizationDAO authorizationDAO;
    TransactionTemplate transactionTemplate;

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action(value="salvar")
    @Input(value="list")
    public ModelAndView salvar(final WebRequestContext request, AuthorizationProcessFilter authorizationFilter) {
        final Role role = authorizationFilter.getRole();
        if (role != null) {
            PermissionLocator permissionLocator;
            Enumeration parameterNames = request.getServletRequest().getParameterNames();
            while (parameterNames.hasMoreElements()) {
                System.out.println(parameterNames.nextElement());
            }
            PermissionLocator permissionLocator2 = permissionLocator = request.getWebApplicationContext().getConfig().getPermissionLocator();
            synchronized (permissionLocator2) {
                permissionLocator.clearCache();
                Collection<List<AuthorizationProcessItemFilter>> values = authorizationFilter.getGroupAuthorizationMap().values();
                final ArrayList<AuthorizationProcessItemFilter> authorizationItemFilters = new ArrayList<AuthorizationProcessItemFilter>();
                for (List<AuthorizationProcessItemFilter> value : values) {
                    authorizationItemFilters.addAll(value);
                }
                this.transactionTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        ControlMappingLocator controlMappingLocator = request.getWebApplicationContext().getConfig().getControlMappingLocator();
                        for (AuthorizationProcessItemFilter filter : authorizationItemFilters) {
                            ControlMapping controlMapping = controlMappingLocator.getControlMapping(filter.getPath());
                            AuthorizationModule authorizationModule = controlMapping.getAuthorizationModule();
                            Map defaultPermissionMap = DefaultAuthorizationProcess.this.getDefaultPermissionMap(authorizationModule);
                            Map<String, String> permissionMap = filter.getPermissionMap();
                            Set defaultKeySet = defaultPermissionMap.keySet();
                            for (String string : defaultKeySet) {
                                if (permissionMap.get(string) != null) continue;
                                permissionMap.put(string, (String)defaultPermissionMap.get(string));
                            }
                            DefaultAuthorizationProcess.this.authorizationDAO.savePermission(filter.getPath(), role, permissionMap);
                        }
                        return null;
                    }
                });
            }
        }
        request.getSession().setAttribute(MenuTag.MENU_CACHE_MAP, null);
        ((DefaultWebRequestContext)request).setLastAction("");
        return this.list(request, authorizationFilter);
    }

    @DefaultAction
    @Input(value="")
    public ModelAndView list(WebRequestContext request, AuthorizationProcessFilter authorizationFilter) {
        authorizationFilter.setGroupAuthorizationMap(new HashMap<String, List<AuthorizationProcessItemFilter>>());
        request.setAttribute("roles", this.authorizationDAO.findAllRoles());
        request.setAttribute("filtro", authorizationFilter);
        if (authorizationFilter.getRole() != null) {
            Class[] controllerClasses;
            HashMap<String, AuthorizationModule> mapaGroupModule = new HashMap<String, AuthorizationModule>();
            Map<String, List<AuthorizationProcessItemFilter>> groupAuthorizationMap = authorizationFilter.getGroupAuthorizationMap();
            Class[] classArray = controllerClasses = this.findControllerClasses(request.getWebApplicationContext());
            int n = controllerClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class controllerClass = classArray[n2];
                Controller controller = controllerClass.getAnnotation(Controller.class);
                try {
                    AuthorizationModule authorizationModule = controller.authorizationModule().newInstance();
                    mapaGroupModule.put(authorizationModule.getAuthorizationGroupName(), authorizationModule);
                    if (!(authorizationModule instanceof HasAccessAuthorizationModule)) {
                        AuthorizationProcessItemFilter[] authorizationProcessItemFilters;
                        AuthorizationProcessItemFilter[] authorizationProcessItemFilterArray = authorizationProcessItemFilters = this.getAuthorizationProcessItemFilter(authorizationFilter.getRole(), controller, authorizationModule);
                        int n3 = authorizationProcessItemFilters.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            AuthorizationProcessItemFilter authorizationProcessItemFilter;
                            AuthorizationProcessItemFilter authorizationItemFilter = authorizationProcessItemFilter = authorizationProcessItemFilterArray[n4];
                            List<AuthorizationProcessItemFilter> list = this.getAuthorizationListForModule(groupAuthorizationMap, authorizationModule);
                            list.add(authorizationItemFilter);
                            ++n4;
                        }
                    }
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("N\u00e3o foi poss\u00edvel instanciar o m\u00f3dulo de autoriza\u00e7\u00e3o", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("N\u00e3o foi poss\u00edvel instanciar o m\u00f3dulo de autoriza\u00e7\u00e3o", e);
                }
                ++n2;
            }
            request.setAttribute("mapaGroupModule", mapaGroupModule);
        }
        request.setAttribute("authorizationProcessItemFilterClass", AuthorizationProcessItemFilter.class);
        return new ModelAndView("process/autorizacao");
    }

    protected List<AuthorizationProcessItemFilter> getAuthorizationListForModule(Map<String, List<AuthorizationProcessItemFilter>> groupAuthorizationMap, AuthorizationModule authorizationModule) {
        String authorizationGroupName = authorizationModule.getAuthorizationGroupName();
        List<AuthorizationProcessItemFilter> list = groupAuthorizationMap.get(authorizationGroupName);
        if (list == null) {
            list = new ArrayList<AuthorizationProcessItemFilter>();
            groupAuthorizationMap.put(authorizationGroupName, list);
        }
        return list;
    }

    protected AuthorizationProcessItemFilter[] getAuthorizationProcessItemFilter(Role role, Controller controller, AuthorizationModule authorizationModule) {
        String[] paths = controller.path();
        ArrayList<AuthorizationProcessItemFilter> authorizationItemFilters = new ArrayList<AuthorizationProcessItemFilter>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            Permission permission = this.authorizationDAO.findPermission(role, path);
            AuthorizationProcessItemFilter authorizationItemFilter = new AuthorizationProcessItemFilter();
            authorizationItemFilter.setAuthorizationModule(authorizationModule);
            authorizationItemFilter.setDescription(this.translatePath(path));
            authorizationItemFilter.setPath(path);
            if (permission == null) {
                permission = this.authorizationDAO.savePermission(path, role, this.getDefaultPermissionMap(authorizationModule));
            }
            authorizationItemFilter.setPermissionMap(permission.getPermissionmap());
            authorizationItemFilters.add(authorizationItemFilter);
            ++n2;
        }
        return authorizationItemFilters.toArray(new AuthorizationProcessItemFilter[authorizationItemFilters.size()]);
    }

    protected String translatePath(String string) {
        return string;
    }

    private Map<String, String> getDefaultPermissionMap(AuthorizationModule authorizationModule) {
        AuthorizationItem[] authorizationItens = authorizationModule.getAuthorizationItens();
        HashMap<String, String> defaultPermissionMap = new HashMap<String, String>();
        AuthorizationItem[] authorizationItemArray = authorizationItens;
        int n = authorizationItens.length;
        int n2 = 0;
        while (n2 < n) {
            AuthorizationItem item = authorizationItemArray[n2];
            String id = item.getId();
            if (item.getValores() == null || item.getValores().length == 0) {
                throw new IllegalArgumentException("Os valores poss\u00edveis de um item de autoriza\u00e7\u00e3o n\u00e3o pode ser um array vazio ou null");
            }
            String valorMaisRestritivo = item.getValores()[item.getValores().length - 1];
            defaultPermissionMap.put(id, valorMaisRestritivo);
            ++n2;
        }
        return defaultPermissionMap;
    }

    protected Class[] findControllerClasses(ApplicationContext applicationContext) {
        return applicationContext.getClassManager().getClassesWithAnnotation(Controller.class);
    }
}

