/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization;

import br.com.linkcom.neo.authorization.AuthorizationManager;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthorizationFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
        config.getInitParameterNames();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        boolean isAuthorized = false;
        HttpSession session = httpServletRequest.getSession();
        ServletContext context = session.getServletContext();
        WebApplicationContext applicationContext = NeoWeb.getWebApplicationContext(context);
        WebRequestContext requestContext = NeoWeb.getRequestContext(httpServletRequest, httpServletResponse);
        AuthorizationManager manager = applicationContext.getAuthorizationManager();
        isAuthorized = manager.isAutorized(requestContext);
        if (isAuthorized) {
            manager.loadPermissions(requestContext);
            chain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendError(403);
        }
    }

    public void destroy() {
    }
}

