/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import br.com.linkcom.neo.view.ComboReloadGroupTag;

public class FunctionCall {
	
	String object;
	String functionName;
	String parameters;
	String call;
	
	
	public String getCall() {
		return call;
	}
	
	public FunctionCall(String call){
		this.call = call.trim();
		Pattern pattern1 = Pattern.compile("(\\w*)\\s*?\\.(\\w*)\\s*?((\\(.*?\\)))");
		Matcher matcher1 = pattern1.matcher(call);
		if(matcher1.find()){
			System.out.println("found "+call);
			//int groupCount = matcher1.groupCount();
			//for (int i = 0; i < groupCount; i++) {
			//	System.out.println(i+ " = "+matcher1.group(i));
			//}
			this.object = matcher1.group(1);
			this.functionName = matcher1.group(2);
			this.parameters = matcher1.group(3);
		} else {
			Pattern pattern2 = Pattern.compile("(\\w*)\\s*?\\.?(\\w*)\\s*?");
			Matcher matcher2 = pattern2.matcher(call);
			if(matcher2.find()){
				System.out.println("found "+call);
				//int groupCount = matcher2.groupCount();
				//for (int i = 0; i < groupCount; i++) {
				//	System.out.println(i+ " = "+matcher2.group(i));
				//}
				this.object = matcher2.group(1);
				this.functionName = matcher2.group(2);
				this.parameters = "";
			} else {
				throw new RuntimeException("Funo fora do padro: "+call);
			}
		}
		
		

		System.out.println(Arrays.deepToString(getParameterArray()));
	}
	
	public FunctionParameter[] getParameterArray(){
		List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
		if(this.parameters == null || this.parameters.trim().length() == 0){
			return new FunctionParameter[0];
		}
		char[] parameterrCharArray = this.parameters.toCharArray();
		
		/*
		boolean started = false;
		boolean inString = false;
		boolean stringAspasSimples = false;
		boolean toCloseString = false;
		boolean escape = false;
		for (int i = 0; i < parameterrCharArray.length; i++) {
			char currentChar = parameterrCharArray[i];
			if(toCloseString){
				if(currentChar == ' '){
					continue;
				}
				if(currentChar != ',' && currentChar != ')'){
					throw new RuntimeException("Funo invlida: "+call+" Esperado: ',' ou ')'  na posio "+i);
				}
				toCloseString = false;
			}
			
			if(!started){
				if(currentChar == '('){
					started = true;
				}
			} else {
				if(currentChar == '\\'){
					if(inString){
						escape = true;
					} else {
						throw new RuntimeException("Funo invlida: "+call+" Caracter '\' inexperado na posio "+i);
					}
				}
				if(currentChar == '\''){
					if(!inString){
						inString = true;
						stringAspasSimples = true;
					} else {
						if(stringAspasSimples && !escape){
							inString = false;
							toCloseString = true;
						}
					}
				}
				if(currentChar == '\"'){
					if(!inString){
						inString = true;
						stringAspasSimples = false;
					} else {
						if(!stringAspasSimples && !escape){
							inString = false;
							toCloseString = true;
						}
					}
				}
				if(!inString && (currentChar == ',' || currentChar == ')')){
					String toString = currentParam.toString();
					if(toString.length() > 0){
						parameters.add(new FunctionParameter(toString.trim()));	
					}
					currentParam = new StringBuilder();
				} else {
					if(!escape) 
						currentParam.append(currentChar);	
					
				}
				
			}
		}
		*/
		int step = 1;
		StringBuilder currentParam = null;
		boolean aspasDuplas = false;
		ParameterType currentType = null;
		for (int i = 0; i < parameterrCharArray.length; i++) {
			char currentChar = parameterrCharArray[i];
			
			try {
				if(String.valueOf(currentChar).equals(ComboReloadGroupTag.PARAMETRO_SEPARATOR)){
					throw new CaracterInvalidoException();
				}
				switch (step) {
					case 1:
						if (currentChar == '(') {
							step = 2;
							continue;
						} else if (currentChar == ' ') {
							continue;
						} else {
							throw new CaracterInvalidoException();
						}
					case 2:
						if(currentParam != null && currentParam.length() > 0){
							parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
						}
						currentParam = new StringBuilder();
						if(currentChar == ' '){
							continue;
						} else if(currentChar == '\''){
							aspasDuplas = false;
							step = 3;
							continue;
						} else if(currentChar == '"'){
							aspasDuplas = true;
							step = 3;
							continue;
						} else if(currentChar == 't'){
							step = 11;
						} else if(currentChar == 'f'){
							step = 12;
						} else if(currentChar == 'u'){
							step = 13;
						} else if(currentChar == ')'){
							if(currentParam.toString().trim().length() > 0){
								parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
							}
							step = 6;
							continue;
						} else if(String.valueOf(currentChar).matches("[0-9]")){
							step = 8;
						} else if(String.valueOf(currentChar).matches("[A-Za-z]")){
							step = 7;
						} else {
							throw new CaracterInvalidoException();
						}
						break;
					case 3:
						currentType = ParameterType.STRING;
						if(currentChar == '"'){
							if(aspasDuplas){
								step = 5;	
								continue;
							}
						} else if(currentChar == '\''){
							if(!aspasDuplas){
								step = 5;	
								continue;
							}
						} else if(currentChar == '\\'){
							step = 4;
							continue;
						}
						break;
					case 4:
						if(currentChar == '\'' || currentChar == '\"' || currentChar == '\\'){
							step = 3;
						} else {
							throw new SequenciaEscapeException();
						}
						break;
					case 5:
						if(currentChar == ' '){
							continue;
						} else if(currentChar == ','){
							step = 2;
							continue;
						} else if(currentChar == ')'){
							parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
							step = 6;
							continue;
						} else {
							throw new CaracterEsperadoException(",");
						}
					case 6:
						break;
					case 7:
						currentType = ParameterType.REFERENCE;
						if(currentChar == ' '){
							step = 5;
							continue;
						} else if (currentChar == ','){
							step = 2;
							continue;
						} else if(currentChar == ')'){
							parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
							step = 6;
							continue;
						}
						break;
					case 8:
						currentType = ParameterType.NUMBER;
						if(currentChar == ' '){
							step = 5;
							continue;
						} else if(currentChar == ',') {
							step = 2;
							continue;
						} else if(currentChar == ')'){
							parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
							step = 6;
							continue;
						} else if(String.valueOf(currentChar).matches("[A-Za-z]")){
							throw new CaracterInvalidoException();
						}
						break;
					case 11:
						currentType = ParameterType.BOOLEAN;
						switch (currentParam.length()) {
							case 1:
								if(currentChar != 'r'){
									step = 7;
								}
								break;
							case 2:
								if(currentChar != 'u'){
									step = 7;
								}
								break;
							case 3:
								if(currentChar != 'e'){
									step = 7;
								}
								break;
							case 4:
								if(currentChar == ' '){
									step = 5;
									continue;
								} else if(currentChar == ','){
									step = 2;
									continue;
								} else if(currentChar == ')'){
									parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
									step = 6;
									continue;
								} else {
									step = 7;
								}
						}
						break;
					case 12:
						currentType = ParameterType.BOOLEAN;
						switch (currentParam.length()) {
							case 1:
								if(currentChar != 'a'){
									step = 7;
								}
								break;
							case 2:
								if(currentChar != 'l'){
									step = 7;
								}
								break;
							case 3:
								if(currentChar != 's'){
									step = 7;
								}
								break;
							case 4:
								if(currentChar != 'e'){
									step = 7;
								}
								break;
							case 5:
								if(currentChar == ' '){
									step = 5;
									continue;
								} else if(currentChar == ','){
									step = 2;
									continue;
								} else if(currentChar == ')'){
									parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
									step = 6;
									continue;
								} else {
									step = 7;
								}
						}
						break;
					case 13:
						currentType = ParameterType.USER;
						switch (currentParam.length()) {
							case 1:
								if(currentChar != 's'){
									step = 7;
								}
								break;
							case 2:
								if(currentChar != 'e'){
									step = 7;
								}
								break;
							case 3:
								if(currentChar != 'r'){
									step = 7;
								}
								break;
							case 4:
								if(currentChar == ' '){
									step = 5;
									continue;
								} else if(currentChar == ','){
									step = 2;
									continue;
								} else if(currentChar == ')'){
									parameters.add(new FunctionParameter(currentParam.toString().trim(), currentType));	
									step = 6;
									continue;
								} else {
									step = 7;
								}
						}
						break;
					default:
						throw new RuntimeException("Ocorreu um erro inesperado ao fazer parsing da funo "+call+" Passo invlido: "+step);
					
				}
				currentParam.append(currentChar);
			} catch (CaracterInvalidoException e) {
				throw new RuntimeException("Funo invlida: "+call+" caracter '"+currentChar+"' invlido na posio "+i);
			} catch (SequenciaEscapeException e) {
				throw new RuntimeException("Funo invlida: "+call+" caracter '"+currentChar+"' invlido na posio "+i+" Sequencia de escape invlida");
			} catch (CaracterEsperadoException e) {
				throw new RuntimeException("Funo invlida: "+call+" caracter '"+currentChar+"' invlido na posio "+i+" Caracter esperado: "+e.getMessage());
			}
		}
		return parameters.toArray(new FunctionParameter[parameters.size()]);
	}
	
	public String getFunctionName() {
		return functionName;
	}
	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}
	public String getObject() {
		return object;
	}
	public void setObject(String object) {
		this.object = object;
	}
	public String getParameters() {
		return parameters;
	}
	public void setParameters(String parameters) {
		this.parameters = parameters;
	}
	
	
}

class CaracterInvalidoException extends Exception {
	private static final long serialVersionUID = 1L;

	public CaracterInvalidoException() {
		super();
	}
	
}

class SequenciaEscapeException extends Exception {
	private static final long serialVersionUID = 1L;

	public SequenciaEscapeException() {
		super();
	}
	
}

class CaracterEsperadoException extends Exception {
	private static final long serialVersionUID = 1L;

	public CaracterEsperadoException(String chars) {
		super(chars);
	}
	
}
