/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.template;

/**
 * @author rogelgarcia
 * @since 03/02/2006
 * @version 1.1
 */
public class TelaTag extends TemplateTag {
	
	protected boolean includeForm = true;
	protected String formAction;
	protected String formMethod = "POST";
	protected String titulo;

	public String getTitulo() {
		return titulo;
	}

	public void setTitulo(String name) {
		this.titulo = name;
	}
	

	public boolean isIncludeForm() {
		return includeForm;
	}

	public void setIncludeForm(boolean includeForm) {
		this.includeForm = includeForm;
	}


	@Override
	protected void doComponent() throws Exception {
		pushAttribute("Ttela", this);
		includeJspTemplate();
		popAttribute("Ttela");
	}

	public String getFormAction() {
		return formAction;
	}

	public void setFormAction(String formAction) {
		this.formAction = formAction;
	}

	public String getFormMethod() {
		return formMethod;
	}

	public void setFormMethod(String formMethod) {
		this.formMethod = formMethod;
	}

}
