/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.template;

import java.io.CharArrayWriter;

import javax.servlet.jsp.tagext.JspFragment;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 03/02/2006
 * @version 1.1
 */
public class EntradaTag extends TemplateTag {

	protected String titulo;
	protected boolean showListagemLink = true;
	protected JspFragment linkArea;

	public JspFragment getLinkArea() {
		return linkArea;
	}

	public void setLinkArea(JspFragment linkArea) {
		this.linkArea = linkArea;
	}

	public boolean isShowListagemLink() {
		return showListagemLink;
	}

	public void setShowListagemLink(boolean showListagemLink) {
		this.showListagemLink = showListagemLink;
	}

	public String getTitulo() {
		return titulo;
	}

	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	@Override
	protected void doComponent() throws Exception {
		if(Util.strings.isEmpty(titulo)){
			titulo = (String) getPageContext().findAttribute("TEMPLATE_beanDisplayName");
		}
		pushAttribute("entradaTag", this);
		includeJspTemplate();
		popAttribute("entradaTag");
	}
	
	/**
	 * mtodo para ser chamado do template
	 * @return
	 */
	public String getInvokeLinkArea(){
		CharArrayWriter charArrayWriter = new CharArrayWriter();
		try {
			if (linkArea != null) {
				linkArea.invoke(charArrayWriter);
			}
		} catch (Exception e) {
			throw new NeoException(e);
		}
		return charArrayWriter.toString();
	}

}
