/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.menu;

import java.util.Iterator;

public class MenuBuilder {
	
	private int identation;
	
	public String build(Menu menu){
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append('[').append('\n');
		identation = 1;
		for (Iterator<Menu> iter = menu.getSubmenus().iterator(); iter.hasNext();) {
			Menu submenu = iter.next();
			build(submenu, stringBuilder,iter.hasNext());
		}
		stringBuilder.append(']');
		return stringBuilder.toString();
	}

	private void build(Menu menu, StringBuilder stringBuilder, boolean hasNext) {
		ident(stringBuilder);
		if(menu.getTitle()!= null && menu.getTitle().matches("--(-)+")){
			stringBuilder.append("_cmSplit");
			if(hasNext){
				stringBuilder.append(',');
			}
			return;
		}
		openMenu(stringBuilder);
		printItem(menu.getIcon(), stringBuilder);
		stringBuilder.append(',');
		printItem(menu.getTitle(), stringBuilder);		
		stringBuilder.append(',');
		
		
		/*
		 * Esse cdigo foi inserido por causa do internet explorer
		 * Quando se tentava fazer download de algum arquivo (relatorio por exemplo)
		 * aparecia a janela de download e ento se fazia o download do arquivo
		 * Quando se pedia atravs do menu a tela do mesmo relatrio aparecia a janela de download 
		 * e no a tela. O cdigo abaixo contorna esse problema.. O parametro fora o IE a pedir a url novamente e por 
		 * consequencia o JSP  mostrado e no a janela de download
		 */
		String url = menu.getUrl();
//		if(url.contains("?")){
//			url += "&NEO_forceReload=";
//		} else {
//			url += "?NEO_forceReload=";
//		}
		
		printItem(url, stringBuilder);
		stringBuilder.append(',');
		printItem(menu.getTarget(), stringBuilder);
		stringBuilder.append(',');
		printItem(menu.getDescription(), stringBuilder);
		if (menu.containSubMenus()) {
			stringBuilder.append(',').append('\n');
			identation++;
			for (Iterator<Menu> iter = menu.getSubmenus().iterator(); iter.hasNext();) {
				Menu submenu = iter.next();
				build(submenu, stringBuilder,iter.hasNext());
			}
			identation--;
			ident(stringBuilder);
			closeMenu(stringBuilder, hasNext);
		} else {
			closeMenu(stringBuilder, hasNext);
		}
	}

	private void closeMenu(StringBuilder stringBuilder, boolean hasNext) {
		stringBuilder.append(']');
		if(hasNext){
			stringBuilder.append(',');
		}
		stringBuilder.append('\n');
	}

	private void printItem(String texto, StringBuilder stringBuilder) {
		stringBuilder.append('\'');
		stringBuilder.append(texto);
		stringBuilder.append('\'');
	}

	private void openMenu(StringBuilder stringBuilder) {
		stringBuilder.append('[');
	}

	private void ident(StringBuilder stringBuilder) {
		for (int i = 0; i < identation; i++) {
			stringBuilder.append("    ");
		}
		
	}
}
