/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.code;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.LogicalTag;

public class ClassTag extends BaseTag implements LogicalTag {

	public static String RUN_METHOD_ATTRIBUTE = "RUN_METHOD_ATTRIBUTE";
	
	public Map<String, JspFragment> metodos = new HashMap<String, JspFragment>();
	
	@Override
	protected void doComponent() throws Exception {
		PrintWriter out = new PrintWriter(new ByteArrayOutputStream());
		getJspBody().invoke(out);
		out.close();
		String runmethod = (String) getRequest().getAttribute(RUN_METHOD_ATTRIBUTE);
		if(runmethod == null){
			runmethod = "main";
		}
		executeMethod(runmethod);
	}
	
	public void executeMethod(String name) throws JspException, IOException{
		JspFragment jspFragment = metodos.get(name);
		if(jspFragment == null){
			throw new NeoException("Mtodo no encontrado: "+name);
		} else {
			jspFragment.invoke(null);
		}
	}
	
	public void registerMethod(String method, JspFragment codigo){
		if(metodos.put(method, codigo) != null){
			throw new NeoException("Mtodo JSP duplicado: "+method);
		}
	}
}
