/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view.ajax;

import br.com.linkcom.neo.controller.ExtendedBeanWrapper;
import br.com.linkcom.neo.controller.ServletRequestDataBinderNeo;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.view.ComboReloadGroupTag;

public class ComboFilter {

	Class type;
	Object parentValue;
	String loadFunction;
	String label;
	String listaParametros;
	String listaClasses;
	public Class[] getClasses(){
		if(listaClasses.length() == 0){
			return new Class[0];
		}
		String[] split = listaClasses.split(ComboReloadGroupTag.CLASS_SEPARATOR);
		Class[] classes = new Class[split.length];
		for (int i = 0; i < classes.length; i++) {
			try {
				classes[i] = Class.forName(split[i]);
			} catch (ClassNotFoundException e) {
				throw new RuntimeException("Classe "+split[i] +" no encontrada");
			}
		}
		return classes;
	}
	
	public Object[] getValues(Class[] classes){
		if(classes.length == 0){
			return new Object[0];
		}
		Object[] values = new Object[classes.length];
		String[] split = listaParametros.split(ComboReloadGroupTag.PARAMETRO_SEPARATOR);
		ExtendedBeanWrapper beanWrapper = new ExtendedBeanWrapper();
		for (int i = 0; i < split.length; i++) {
			Object value = split[i];
			if(ServletRequestDataBinderNeo.isObjectValue(value)){
				value = ServletRequestDataBinderNeo.translateObjectValue("[?]", value, null);
			}
			if("user".equals(value)){
				value = Neo.getRequestContext().getUser();
			}
			values[i] = beanWrapper.doTypeConversionIfNecessary(value, classes[i]);
		}
		return values;
	}
	
	public String getListaClasses() {
		return listaClasses;
	}
	public void setListaClasses(String listaClasses) {
		this.listaClasses = listaClasses;
	}
	public String getListaParametros() {
		return listaParametros;
	}
	public void setListaParametros(String listaParametros) {
		this.listaParametros = listaParametros;
	}
	public String getLabel() {
		return label;
	}
	public void setLabel(String label) {
		this.label = label;
	}

	public String getLoadFunction() {
		return loadFunction;
	}
	public void setLoadFunction(String loadFunction) {
		this.loadFunction = loadFunction;
	}

	public Object getParentValue() {
		return parentValue;
	}
	public void setParentValue(Object parentValue) {
		this.parentValue = parentValue;
	}
	public Class getType() {
		return type;
	}
	public void setType(Class type) {
		this.type = type;
	}
}
