/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author rogelgarcia
 * @since 31/01/2006
 * @version 1.1
 */
public class TabPanelTag extends BaseTag implements AcceptPanelRenderedBlock {

	protected List<PanelRenderedBlock> blocks = new ArrayList<PanelRenderedBlock>();

	@Override
	protected void doComponent() throws Exception {
		doBody();
		String idTabPanel = id != null? id: generateUniqueId();
		int currentPanel = 0;
		List<TabPanelBlock> tabBlocks = new ArrayList<TabPanelBlock>();
		for (PanelRenderedBlock block : blocks) {
			tabBlocks.add(new TabPanelBlock(block, idTabPanel, currentPanel++));
		}
		int selectedIndex = 0;
		//verificar se j existia algum pr-selecionado
		if(id != null){
			String index = getRequest().getParameter("TABPANEL_"+id);
			if(index != null){
				selectedIndex = Integer.parseInt(index);
			}
		}
		
		renderScript(idTabPanel, tabBlocks, selectedIndex);
		renderSelectArea(idTabPanel, tabBlocks, selectedIndex);
		renderPanels(idTabPanel, tabBlocks, selectedIndex);
	}

	private void renderPanels(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
		int index = 0;
		if(tabBlocks.size() == 1){
			getOut().println(tabBlocks.get(0).getBody());
		} else {
			for (TabPanelBlock block : tabBlocks) {
				if(index == selectedIndex){
					getOut().print("<div style=\"width: 100%; \" id=\""+block.getId()+"\">");	
				} else {
					getOut().print("<div style=\"width: 100%; display: none;\" id=\""+block.getId()+"\">");
				}
				getOut().println(block.getBody());
				getOut().print("</div>");
				index ++;
			}	
		}
		
	}

	private void renderSelectArea(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
		int index = 0;
		if(tabBlocks.size() > 1){
			getOut().print("<div class=\"tabPanelLink\">");
			for (int i = 0; i < tabBlocks.size(); i++) {
				TabPanelBlock block = tabBlocks.get(i);
				String className = i==selectedIndex? "detailTabSelected" : "detailTabUnselected";
				String linkId = createLinkId(idTabPanel, i);
				getOut().print("<a href=\"javascript:show"+idTabPanel+"('"+block.getId()+"', "+index+", '"+linkId+"'); "+escape(block.getOnSelectTab())+"\" class=\""+className+"\" id=\""+linkId+"\">"+block.getTitle()+"</a> ");
				index++;
			}
			getOut().print("</div>");
		}
		
	}

	private String createLinkId(String idTabPanel, int i) {
		return (idTabPanel+"_link_"+i);
	}

	private void renderScript(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
		if(tabBlocks.size() <= 1) return;
		if(id != null){
			getOut().println("<input type=\"hidden\" name=\"TABPANEL_"+idTabPanel+"\" value=\""+selectedIndex+"\"/>");
		}
		FormTag form = findParent(FormTag.class);
		getOut().println("<script language=\"javascript\">");
		getOut().println("    function show" + idTabPanel + "(panel, index, linkid) {");
		for (int i = 0; i < tabBlocks.size(); i++) {
			TabPanelBlock block = tabBlocks.get(i);
			String linkId = createLinkId(idTabPanel, i);
			getOut().println("        hide" + idTabPanel + "('" + block.getId() + "')");
			getOut().println("        unselect" + idTabPanel + "('" + block.getId() + "', '"+linkId+"')");
		}
		getOut().println("        document.getElementById(panel).style.display = '';");
		getOut().println("        select" + idTabPanel + "(panel, index, linkid);");
		getOut().println("    }");
		getOut().println("    function hide" + idTabPanel + "(panel) {");
		getOut().println("        document.getElementById(panel).style.display = 'none';");
		getOut().println("    }");

		getOut().println("    function select" + idTabPanel + "(panel, index, linkid) {");
		if(form != null && id != null){
			getOut().println("        "+form.getName()+".TABPANEL_"+idTabPanel+".value = index;");
		}
		getOut().println("        document.getElementById(linkid).className = 'detailTabSelected';");
		getOut().println("    }");

		getOut().println("    function unselect" + idTabPanel + "(panel, linkid) {");
		getOut().println("        document.getElementById(linkid).className = 'detailTabUnselected';");
		getOut().println("    }");
		getOut().println("</script>");
	}

	public boolean addBlock(PanelRenderedBlock o) {
		return blocks.add(o);
	}

}

class TabPanelBlock {

	private PanelRenderedBlock block;

	private String idTabPanel;

	private Integer tabNumber;

	public TabPanelBlock(PanelRenderedBlock block, String idTabPanel, Integer tabNumber) {
		this.block = block;
		this.idTabPanel = idTabPanel;
		this.tabNumber = tabNumber;
	}

	public String getId() {
		return idTabPanel + "_" + tabNumber;
	}
	
	public String getOnSelectTab(){
		String string = (String) block.getProperties().get("onselecttab");
		if(string == null){
			string = "";
		}
		return string;
	}
	
	public String getTitle(){
		String title = (String) block.getProperties().get("title");
		if(title == null){
			return "No title attribute ("+tabNumber+")";
		} else {
			return title;
		}
	}
	
	public String getBody(){
		return block.getBody();
	}
}
