/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.linkcom.neo.controller.resource.Resource;

public class ResourceServlet extends HttpServlet {

	private static final String RESOURCE_LASTMOD = "RESOURCE_LASTMOD";

	public static final String RESOURCE = "resource";

	private static final long serialVersionUID = 1L;

	protected Map<String, String> map = new HashMap<String, String>();
	
	public ResourceServlet(){
		map.put("js/validation", "br/com/linkcom/neo/resource");
		map.put("js/inputs", 	 "br/com/linkcom/neo/resource");
		map.put("js/ajax",       "br/com/linkcom/neo/resource");
		map.put("js/util",       "br/com/linkcom/neo/resource");
		map.put("js",            "br/com/linkcom/neo/resource");
		map.put("menu",       	 "br/com/linkcom/neo/resource/menu");
		map.put("htmlarea",      "br/com/linkcom/neo/resource/htmlarea");
		map.put("css",           "br/com/linkcom/neo/resource");
		map.put("img",           "br/com/linkcom/neo/resource/imgs");
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		String requestResource = getRequestedResource(request);
		int indexOfFile = requestResource.lastIndexOf('/');
		String tipo;
		String file = null;
		if(indexOfFile < 0){
			tipo = requestResource;
		} else {
			tipo = requestResource.substring(0, indexOfFile);
			file = requestResource.substring(indexOfFile);
		}
		
		

		if(tipo.equals(RESOURCE)){
			HttpSession session = request.getSession();
			Integer id = new Integer(request.getParameter("id"));
			Resource recurso = ResourceUtil.get(session, id);
			if (recurso != null) {
				response.setContentType(recurso.getContentType());
				response.setHeader("Content-Disposition", "attachment; filename=\"" + recurso.getFileName()	+ "\";");
				response.getOutputStream().write(recurso.getContents());
			}
		} else {
	        String basePath = map.get(tipo);
			if(basePath == null){
				response.sendError(HttpServletResponse.SC_NOT_FOUND);
			}
			String resourcePath = basePath+file;
			//request.getSession().getServletContext().getResourceAsStream("/WEB-INF/classes/"+
			//this.getClass().getClassLoader().getResourceAsStream(
			
			//verificar se o recurso existe na aplicaao (NEO aberto)
			boolean useLastModified = true;
	        InputStream inputStream = request.getSession().getServletContext().getResourceAsStream("/WEB-INF/classes/"+resourcePath);
	        if(inputStream == null){
	        	//procurar no classpath (utiliza JAR)
	        	useLastModified = true; // usamos o lastModified apenas para o JAR porque no outro modo alteraes tem que ser enviadas para o cliente
	        	inputStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
	        }
			
			if (inputStream != null) {
				if(useLastModified && request.getSession().getServletContext().getAttribute(RESOURCE_LASTMOD+resourcePath) == null){
					request.getSession().getServletContext().setAttribute(RESOURCE_LASTMOD+resourcePath, System.currentTimeMillis());					
				}
				
	            
				InputStream in = new BufferedInputStream(inputStream);
				OutputStream out = response.getOutputStream();
				
				String ae = request.getHeader("accept-encoding");
				if (ae != null && ae.indexOf("gzip") != -1 && (requestResource.endsWith("js") || requestResource.endsWith("css"))) {
					response.addHeader("Content-Encoding", "gzip");
					out = new GZIPOutputStream(out);
				}
				
				int b = 0;
				while ((b = in.read()) != -1) {
					out.write(b);
				}
				 
				/*
				byte[] buffer = new byte[8192];
				int read;
				while((read = in.read(buffer)) != -1){
					out.write(buffer, 0, read);
				}
				*/
				if(out instanceof GZIPOutputStream){
					((GZIPOutputStream)out).finish();
				}
				
				out.flush();
			} else {
				response.sendError(HttpServletResponse.SC_NOT_FOUND);
			}			
		}

	}

	private String getRequestedResource(HttpServletRequest request) {
		String requestURI = request.getRequestURI();
		requestURI = requestURI.replace((CharSequence)"//", "/");
		String servletPath = request.getServletPath();
		int s = requestURI.indexOf(servletPath)+servletPath.length()+1;
		String requestResource = requestURI.substring(s);
		return requestResource;
	}

    @Override
    protected long getLastModified(HttpServletRequest request) {
    	String requestResource = getRequestedResource(request);
		int indexOfFile = requestResource.lastIndexOf('/');
		String tipo;
		String file = null;
		if(indexOfFile < 0){
			tipo = requestResource;
		} else {
			tipo = requestResource.substring(0, indexOfFile);
			file = requestResource.substring(indexOfFile);
		}
		if(!tipo.equals(RESOURCE)){
			String basePath = map.get(tipo);
			if(basePath != null){
				String resourcePath = basePath+file;
				Object last = request.getSession().getServletContext().getAttribute(RESOURCE_LASTMOD+resourcePath);
				if(last != null){
					return (Long)last;
				}
			}
			
		}
    	return -1;
    }

}
