/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import org.hibernate.LazyInitializationException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.PageContextIndexResolver;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.core.web.NeoWeb;

/**
 * @author rogelgarcia
 * @since 26/01/2006
 * @version 1.1
 */
public class PropertyTag extends BaseTag implements LogicalTag {
	
	protected String name;
	protected String varValue = "value";
	protected String varError = "error";
	protected String varLabel = "label";
	protected String varName = "name";
	protected String varType = "type";
	protected String varParameterizedTypes = "parameterizedTypes";
	protected String varPropertySetter = "propertySetter";
	protected String varAnnotations = "annotations";
	
	/** Name para ser utilizado no input completo */
	protected String fullName;  //nome do input
	/** nome da propriedade comeando do bean */
	protected String fullNestedName; //nome da propriedade comeando do bean


	public String getFullNestedName() {
		return fullNestedName;
	}

	@Override
	protected void doComponent() throws Exception {
		BindException errors = NeoWeb.getRequestContext().getBindException();
		montarFullPropertyName();
		montarFullNestedName();
		final BeanDescriptor beanDescriptor = findParent(BeanTag.class, true).getBeanDescriptor();
		beanDescriptor.setIndexValueResolver(new PageContextIndexResolver(getPageContext()));
		PropertyDescriptor propertyDescriptor = null;
		if(!"".equals(fullNestedName)){
			propertyDescriptor = beanDescriptor.getPropertyDescriptor(fullNestedName);	
		}
		
		FieldError error = errors.getFieldError(fullName);
		@SuppressWarnings("unchecked")
		boolean containError = errors.hasErrors() && errors.getTarget().getClass().equals(beanDescriptor.getTargetClass())
				&& error != null;
		Type type;
		if (propertyDescriptor != null) {
			type = propertyDescriptor.getType();
		} else {
			type = beanDescriptor.getTargetClass();
		}
		Type[] actualTypeArguments = new Type[0];
		if(containError){
			pushAttribute(varValue, error.getRejectedValue()); // se tiver algum valor.. vale o valor setado
			pushAttribute(varError, error.getDefaultMessage());
			pushAttribute(varType, type);
			if(type instanceof ParameterizedType){
				actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
			}
			pushAttribute(varParameterizedTypes, actualTypeArguments);
		} else {
			try {
				Object propertyValue;
				if (propertyDescriptor != null) {
					propertyValue = propertyDescriptor.getValue();
				} else {
					propertyValue = beanDescriptor.getTargetBean();
				}
				Object value = propertyValue;
				pushAttribute(varValue, value);
				pushAttribute(varType, type);
				if(type instanceof ParameterizedType){
					actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
				}
				pushAttribute(varParameterizedTypes, actualTypeArguments);
			} catch (LazyInitializationException e) {
				pushAttribute(varValue, "[Could not initializate proxy] "+propertyDescriptor.getPropertyName());
				pushAttribute(varType, String.class);
			}
		}
		if (propertyDescriptor != null) {
			pushAttribute(varLabel, propertyDescriptor.getDisplayName());
		} else {
			pushAttribute(varLabel, beanDescriptor.getDisplayName());
		}
		pushAttribute(varName, fullName);//TODO FAZER SUPORTE A MAPAS.. QUANDO  MAPA O NOME PODE SER MODIFICADO
		
		if(propertyDescriptor != null){
			
			PropertySetter propertySetter = new PropertySetter(){

				public void set(Object value) {
					Object targetBean = beanDescriptor.getTargetBean();
					BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(targetBean);
					beanWrapperImpl.setPropertyValue(fullNestedName, value);
				}
				
			};
			pushAttribute(varPropertySetter, propertySetter);	
		}
		
		if (propertyDescriptor != null) {
			pushAttribute(varAnnotations, propertyDescriptor.getAnnotations());
		} else {
			pushAttribute(varAnnotations, new Annotation[0]);
		}
		
		doBody();
		if(containError){
			popAttribute(varError);
		}
		if(propertyDescriptor != null){
			popAttribute(varPropertySetter);	
		}
		popAttribute(varValue);
		popAttribute(varLabel);
		popAttribute(varName);
		popAttribute(varType);
		popAttribute(varAnnotations);
		popAttribute(varParameterizedTypes);
		
	}
	
	@SuppressWarnings("unchecked")
	protected void montarFullNestedName() {
//		PropertyTag propertyTag = findParent(PropertyTag.class);
//		if(propertyTag != null){
//			String parentFullNestedName = propertyTag.getFullNestedName();
//			if(!name.startsWith("[")){
//				name = "." +name;
//			}
//			fullNestedName = parentFullNestedName + name;
//		} else {
//			if("this".equals(name)){
//				fullNestedName = "";
//				return;
//			}
//			fullNestedName = name;
//		}
		BaseTag firstParent = findFirst(ForEachBeanTag.class, PropertyTag.class, BeanTag.class);
		String separator = name.startsWith("[")?"":".";
		if(firstParent instanceof PropertyTag){
			fullNestedName = ((PropertyTag)firstParent).getFullNestedName()+separator+name;
		} else {
			fullNestedName = name;
		}
	}

	@SuppressWarnings("unchecked")
	protected void montarFullPropertyName() {
		BaseTag firstParent = findFirst(ForEachBeanTag.class, PropertyTag.class, BeanTag.class);
		String separator = name.startsWith("[")?"":".";
		if(firstParent instanceof PropertyTag){
			fullName = ((PropertyTag)firstParent).getFullName()+separator+name;
		} else {
			BeanTag parentBean = ((BeanTag)firstParent);
			if(parentBean == null){
				throw new NullPointerException("Tag property ("+name+") no est aninhada a uma outra tag Property ou Bean");
			}
			String propertyPrefix = parentBean.getPropertyPrefix();
			String propertyIndex = parentBean.getPropertyIndex();
			String prefix = "";
			if(propertyPrefix != null){
				prefix = propertyPrefix;
			} 
			if(propertyIndex != null){
				prefix += "["+propertyIndex+"]";
			} 
			if(prefix.length()!=0 && name != null && !name.equals("this")){
				prefix += ".";
			}
			if("this".equals(name) || name == null){
				fullName = prefix;
				return;
			}
			fullName = prefix+name;
		}
	}


	public String getFullName() {
		return fullName;
	}
	
	public String getVarAnnotations() {
		return varAnnotations;
	}

	public String getVarLabel() {
		return varLabel;
	}

	public String getName() {
		return name;
	}

	public String getVarName() {
		return varName;
	}

	public String getVarValue() {
		return varValue;
	}

	public void setVarAnnotations(String annotationsVar) {
		this.varAnnotations = annotationsVar;
	}

	public void setVarLabel(String displayNameVar) {
		this.varLabel = displayNameVar;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setVarName(String nameVar) {
		this.varName = nameVar;
	}

	public void setVarValue(String valueVar) {
		this.varValue = valueVar;
	}

	public String getVarParameterizedTypes() {
		return varParameterizedTypes;
	}

	public String getVarType() {
		return varType;
	}

	public void setVarParameterizedTypes(String varParameterizedTypes) {
		this.varParameterizedTypes = varParameterizedTypes;
	}

	public void setVarType(String varType) {
		this.varType = varType;
	}

}
