/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.types.File;
import br.com.linkcom.neo.util.Util;

/**
 * @author rogelgarcia
 * @since 27/01/2006
 * @version 1.1
 */
public class OutputTag extends BaseTag {
	
	protected Object value;
	//quando value for number ou date
	protected String pattern;
	protected String itemSeparator;
	protected String styleClass;
	protected String style;
	protected String trueFalseNullLabels = "Sim,No,";
	
	
	protected boolean escapeHTML = false;

	public boolean isEscapeHTML() {
		return escapeHTML;
	}

	public void setEscapeHTML(boolean escapeHTML) {
		this.escapeHTML = escapeHTML;
	}

	public String getTrueFalseNullLabels() {
		return trueFalseNullLabels;
	}

	public void setTrueFalseNullLabels(String trueFalseNullLabels) {
		this.trueFalseNullLabels = trueFalseNullLabels;
	}

	@Override
	protected void doComponent() throws Exception {
		if(style != null || styleClass != null){
			getOut().print("<span");
			if(style!= null){
				getOut().print(" style='"+style+"'");
			}
			if(styleClass!= null){
				getOut().print(" class='"+styleClass+"'");
			}
			getOut().print(">");
		}
		if(value == null){
			value = getPageContext().findAttribute("value");
		}
		try {
			if ((value instanceof Boolean || value == null) && Util.strings.isNotEmpty(trueFalseNullLabels)) {
				String[] split = trueFalseNullLabels.split(",");
				String trueString = split[0];
				String falseString = split[1];
				String nullString = "";
				if (split.length == 3) {
					nullString = split[2];
				}
				if (value == null) {
					value = nullString;
				} else if (value instanceof Boolean) {
					if (((Boolean) value)) {
						value = trueString;
					} else {
						value = falseString;
					}
				}
			} else if(value instanceof Boolean) {
				if (((Boolean) value)) {
					value = "Sim";
				} else {
					value = "No";
				}
			}
		} catch (ArrayIndexOutOfBoundsException e) {
			throw new NeoException("trueFalseNullLabels invlido "+trueFalseNullLabels+". Esse atributo deve ser uma string separada por vrgula indicando o valor de TRUE FALSE e NULL. ex.: sim,no,vazio");
		}
		
		if((value instanceof Date || value instanceof java.sql.Date || value instanceof Timestamp) && Util.strings.isEmpty(pattern)){
			pattern = "dd/MM/yyyy";
		}
		if(pattern != null){
			if(value instanceof Date || value instanceof java.sql.Date || value instanceof Timestamp){
				String valueToString = new SimpleDateFormat(pattern).format(value);
				getOut().print(valueToString);
			} else if (value instanceof Number){
				Number number = (Number) value;
				String valueToString = new DecimalFormat(pattern).format(number);
				getOut().print(valueToString);
			} else {
				getOut().print(getObjectDescriptionToString(value));	
			}
		} else {
			if(value instanceof File){
				File file = (File) value;
				DownloadFileServlet.addCdfile(getRequest().getSession(), file.getCdfile());
				getOut().print("<a href=\""+getRequest().getContextPath()+DownloadFileServlet.DOWNLOAD_FILE_PATH+"/"+file.getCdfile()+"\">");
				getOut().print(file.getName());
				getOut().print("</a>");
			} else {
				String objectDescriptionToString = getObjectDescriptionToString(value);
				if(objectDescriptionToString!=null){
					getOut().print(objectDescriptionToString.replaceAll("<", "&lt;").replaceAll("\n","<BR>"));	
				}
					
			}
				
		}
		
		
		if(style != null || styleClass != null){
			getOut().print("</span>");
		}
	}
	
	public String getItemSeparator() {
		return itemSeparator;
	}

	public String getPattern() {
		return pattern;
	}

	public String getStyle() {
		return style;
	}

	public String getStyleClass() {
		return styleClass;
	}

	public Object getValue() {
		return value;
	}

	public void setItemSeparator(String itemSeparator) {
		this.itemSeparator = itemSeparator;
	}

	public void setPattern(String pattern) {
		this.pattern = pattern;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	public void setValue(Object value) {
		this.value = value;
	}


}
