package br.com.linkcom.neo.view;

import java.util.HashMap;
import java.util.Map;

import ognl.Ognl;
import ognl.OgnlException;

import org.springframework.beans.BeanWrapperImpl;

import br.com.linkcom.neo.exception.ExpressionParseException;

/**
 * @author rogelgarcia
 * @since 27/10/2005
 * @version 1.0
 */
public class OgnlExpressionParser {

	public static Map<String, Object> expressionCache = new HashMap<String, Object>();

	public static Object parse(String expression, Map contextMap) throws ExpressionParseException{
		Object value;
		try {
			Object tree = getExpressionTree(expression);
			value = Ognl.getValue(tree, (Object)contextMap, null);
		} catch (OgnlException e) {
			throw new ExpressionParseException("Erro ao fazer parsing de "+expression, e);
		}
		return value;
	}

	public static <X> X parse(String expression, Class<X> expectedClass, Map contextMap) throws ExpressionParseException {
		Object value;
		try {
			Object tree = getExpressionTree(expression);
			value = Ognl.getValue(tree, (Object)contextMap, null);
		} catch (OgnlException e) {
			if(!e.getMessage().startsWith("source is null")){
				throw new ExpressionParseException("Erro ao fazer parsing de "+expression, e);	
			} else {
				value = null;
			}
			
		}
		if(value != null && !expectedClass.isAssignableFrom(value.getClass())){
			BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl();
			value = beanWrapperImpl.doTypeConversionIfNecessary(value, expectedClass);
		}
		
		if(value != null && !expectedClass.isAssignableFrom(value.getClass())){			
			if(value != null && String.class.isAssignableFrom(expectedClass)){
				@SuppressWarnings("unchecked")
				X toString = (X) value.toString();
				return toString;
			}
			throw new ExpressionParseException("A expresso #{"+expression+"} retornou um objeto do tipo "+value.getClass().getName()+" era esperado "+expectedClass.getName()+"! No foi possvel fazer a converso");
		}
		@SuppressWarnings("unchecked") 
		X x = (X)value;

		return x;
	}

	

	private static Object getExpressionTree(String expression) throws OgnlException {
		Object tree = expressionCache.get(expression);
		if(tree == null){
			synchronized (expressionCache) {
				tree = expressionCache.get(expression);
				if (tree == null) {
					tree = Ognl.parseExpression(expression);
					expressionCache.put(expression, tree);
				}
			}
		}
		return tree;
	}
	
}
