/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.util.Collection;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.PageContextIndexResolver;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.exception.NeoException;

public class ForEachBeanTag extends PropertyTag  {

	protected String property;
	protected String var = "bean";
	protected String varIndex = "index";
	
	public String getVarIndex() {
		return varIndex;
	}

	public void setVarIndex(String varIndex) {
		this.varIndex = varIndex;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	@Override
	protected void doComponent() throws Exception {
		setName(getProperty());//simula colocar um <n:property> para configurar os fullnestedname, etc
		
		montarFullPropertyName();
		montarFullNestedName();
		
		
		final BeanDescriptor beanDescriptor = findParent(BeanTag.class, true).getBeanDescriptor();
		beanDescriptor.setIndexValueResolver(new PageContextIndexResolver(getPageContext()));
		PropertyDescriptor propertyDescriptor = null;
		if(!"".equals(fullNestedName)){
			propertyDescriptor = beanDescriptor.getPropertyDescriptor(fullNestedName);	
		}
		if(propertyDescriptor == null){
			throw new NeoException("Erro na tag forEachBean. No foi possvel achar o property descriptor para a propriedade "+fullNestedName);
		}
		Object value = propertyDescriptor.getValue();
		if(!(value instanceof Collection) && value != null){
			throw new NeoException("Erro na tag forEachBean. O property leva a um atributo que no  uma coleo. Valor encontrado"+value);			
		}
		if(value != null){
			Collection collection = (Collection) value;
			String fullName = this.fullName;  //nome do input
			String fullNestedName = this.fullNestedName; //nome da propriedade comeando do bean
			int i = 0;
			for (Object object : collection) {
				pushAttribute(var, object);
				pushAttribute(varIndex, i);
				
				this.fullName = fullName + "["+i+"]";
				this.fullNestedName = fullNestedName + "["+i+"]";
				doBody();
				
				i++;
				popAttribute(varIndex);
				popAttribute(var);
			}
		}
	}
}
