/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.jstl.core.LoopTagStatus;

import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.combo.ComboTag;
import br.com.linkcom.neo.view.combo.ComboTag.TagHolder;


/**
 * @author rogelgarcia
 * @since 27/01/2006
 * @version 1.1
 */
public class DataGridTag extends BaseTag {
	
	protected String property;
	protected Object itemType;
	protected Object itens;
	protected String style;
	protected String styleClass = "dataGrid";
	protected String headerStyleClass = "dataGridHeader";
	protected String headerStyle;
	protected String bodyStyleClasses = "dataGridBody1, dataGridBody2";
	protected String bodyStyles;
	protected String footerStyleClass = "dataGridFooter";
	protected String footerStyle;
	protected Boolean dynaLine = false;
	
	protected String varStatus;
	protected String var = "row";
	protected String varIndex = "index";
	protected String varRowIndex = "rowIndex";
	
	public enum Status {REGISTER, HEADER, BODY, DYNALINE, FOOTER}
	
	//extra
	protected Status currentStatus = Status.REGISTER;
	protected boolean renderHeader = false;
	protected boolean renderBody = false;
	protected boolean renderFooter = false;
	
	//dynaline
	protected List<PanelRenderedBlock> blocks = new ArrayList<PanelRenderedBlock>();
	
	//configuracao dos rows
	private Map<String, CyclicIterator> rowAttributes = new LinkedHashMap<String, CyclicIterator>();
	private String rowSeparator;
	/**
	 * Esse atributo nao  utilzado
	 */
	private String row;
	
	//informacoes do loopTagStatus
	protected Object _current;
	protected int _index;
	protected int _count;
	protected boolean _isFirst;
	protected boolean _isLast;
	protected Integer _begin = 0;
	protected Integer _end;
	protected Integer _step = 1;

	
	Iterator<String> bodyStyleIterator;
	Iterator<String> bodyStyleClassIterator;
	
	protected List<ColumnTag> columns = new ArrayList<ColumnTag>();
	
	private boolean hasColumns = false; // informa se esse dataGrid tem tags Columns no seu corpo
	
	@Override
	@SuppressWarnings("unchecked")
	protected void doComponent() throws Exception {
		if(itens != null && property != null){
			throw new RuntimeException("O dataGrid no pode ter as propriedades property e itens configuradas ao mesmo tempo. ");
		}
		if(itemType != null && property != null){
			throw new RuntimeException("O dataGrid no pode ter as propriedades property e itemType configuradas ao mesmo tempo. ");
		}
		if(property != null){
			PropertyTag propertyTag = new PropertyTag();
			propertyTag.setName(property);
			TagHolder tagHolderPropertyTag = new ComboTag.TagHolder(propertyTag);
			
			
			this.property = null;
			TagHolder tagHolderDataGrid = new ComboTag.TagHolder(this, "itens", "${value}");
			BeanTag beanTag = new BeanTag();
			beanTag.setJspBody(getJspBody());
			
			tagHolderPropertyTag.addChild(tagHolderDataGrid);
			TagHolder tagHolderBean = new ComboTag.TagHolder(beanTag, "name", var, "valueType", "${parameterizedTypes[0]}", "propertyIndex", "${"+varIndex+"}", "propertyPrefix", "${name}");
			tagHolderDataGrid.addChild(tagHolderBean);
			ComboTag.TagHolderFragment fragment = new ComboTag.TagHolderFragment(getJspContext(), Arrays.asList(tagHolderPropertyTag), this);
			fragment.invoke(getOut());
			return;
		} else if(itemType != null){
			if(!(itemType instanceof String) && !(itemType instanceof Class)){
				throw new RuntimeException("O atributo item type deve ser do typo String ou Class");
			}
			Class itemClass;
			try {
				itemClass = (Class) (itemType instanceof Class ? itemType : Class.forName((String) itemType));
			} catch (ClassNotFoundException e) {
				throw new RuntimeException("Atributo itemType invlido: "+itemType, e);
			}
			BeanTag beanTag = new BeanTag();
			beanTag.setName(var);
			beanTag.setValueType(itemClass);
			beanTag.setJspBody(getJspBody());
			TagHolder tagHolderBeanTag = new ComboTag.TagHolder(beanTag);
			this.itemType = null;
			
			TagHolder tagHolderDataGrid = new ComboTag.TagHolder(this);
			
			tagHolderDataGrid.addChild(tagHolderBeanTag);
			
			
			ComboTag.TagHolderFragment fragment = new ComboTag.TagHolderFragment(getJspContext(), Arrays.asList(tagHolderDataGrid), getParent());
			fragment.invoke(getOut());
			
			return;
		}
		Object requestObject = getRequest().getAttribute(var);
		Object sessionObject = getRequest().getSession().getAttribute(var);
		Object contextAttribute = getRequest().getSession().getServletContext().getAttribute(var);
		
		// o var que estava no escopo deve ser retirado (ele  recolocado no final da tag)
		getRequest().setAttribute(var, null);
		getRequest().getSession().setAttribute(var, null);
		getRequest().getSession().getServletContext().setAttribute(var, null);
		
		
		if (itens != null && itens instanceof String) {
			String expression = (String) itens;
			Object value = getOgnlValue(expression, Collection.class);
			itens = value;
		}
		if(itens != null && itens.getClass().isArray()){
			if (!itens.getClass().getComponentType().isPrimitive()) {
				Object[] array = (Object[]) itens;
				itens = new ArrayList();
				for (int i = 0; i < array.length; i++) {
					((List) itens).add(array[i]);
				}
			}
		}
		
		if(itens == null){ // se os itens forem null funcionar como se fosse uma tabela vazia
			itens = new ArrayList();
		}
		if(!(itens instanceof Collection)){
			throw new IllegalArgumentException("Tipo de itens no suportado por dataGrid: "+itens);
		}
		bodyStyleIterator = getBodyStyles();
		bodyStyleClassIterator = getBodyStyleClasses();
		
		
		//configurar os iterators dos rows
		Set<String> daKeys = new LinkedHashSet<String>(getDynamicAttributesMap().keySet());
		for (String daKey : daKeys) {
			if(daKey.startsWith("row")){

				CyclicIterator cyclicIterator = new CyclicIterator(toStringArray(getDynamicAttributesMap().get(daKey)));
				rowAttributes.put(daKey.substring(3), cyclicIterator);
				getDynamicAttributesMap().remove(daKey);
			}
		}
		
		String styleString = style!=null?" style=\""+style+"\"":"";
		String classString = styleClass!=null?" class=\""+styleClass+"\"":"";
		String id = this.id == null? "" : "id=\""+this.id+"\"";
		if(!getDynamicAttributesMap().containsKey("width")){
			getDynamicAttributesMap().put("width", "100%");
		}
		if(!getDynamicAttributesMap().containsKey("cellspacing")){
			getDynamicAttributesMap().put("cellspacing", "1");
		}
		
		
		//etapa de registro
		if (getJspBody()!=null) {
			PrintWriter writer = new PrintWriter(new ByteArrayOutputStream());
			getJspBody().invoke(writer);
		}
		
		if(hasColumns){
			getOut().println("<table"+styleString+classString+getDynamicAttributesToString()+id+">");
			
			if (renderHeader) {
				currentStatus = Status.HEADER;
				renderHeader();
			}
			

			Collection collection = (Collection) itens;
			if (Util.strings.isNotEmpty(varStatus)) {
				getRequest().setAttribute(varStatus, getLoopTagStatus());
			}
			currentStatus = Status.BODY;
			_count = collection.size();
			if (_end == null) {
				_end = _count - 1;
			}
			//modificado por pedro em 14 maio 2007
			getOut().print("<tbody>");
			
			iterate(collection);
			
			getOut().print("</tbody>");
			
			if (renderFooter) {
				currentStatus = Status.FOOTER;
				renderFooter();
			}
			
			getOut().println("</table>");
			
			if(dynaLine){
				currentStatus = Status.DYNALINE;
				pushAttribute("dataGridDynaline", true);
				renderDynaLine();
				popAttribute("dataGridDynaline");
			}
		} else {
			Collection collection = (Collection) itens;
			if (Util.strings.isNotEmpty(varStatus)) {
				getRequest().setAttribute(varStatus, getLoopTagStatus());
			}
			currentStatus = Status.BODY;
			_count = collection.size();
			if (_end == null) {
				_end = _count - 1;
			}
			iterate(collection);
		}
		
		


		getRequest().setAttribute(var, requestObject);
		getRequest().getSession().setAttribute(var, sessionObject);
		getRequest().getSession().getServletContext().setAttribute(var, contextAttribute);
	}

	private String[] toStringArray(Object object) {
		if(object == null){
			object = "";
		}
		if(rowSeparator == null){
			return new String[]{object.toString()};
		}
		return object.toString().split(rowSeparator);
	}

	private void renderDynaLine() throws ELException, IOException, JspException, ServletException {
		getRequest().setAttribute(var, null);
		getRequest().setAttribute(varIndex, "{index}");
		getRequest().setAttribute(varRowIndex, "{indexplus}");
		
		doBody();
		
		
		//getOut().print("</tr>");
		getOut().println("<script language=\"javascript\">");
		List<String> tdBodys = new ArrayList<String>();
		for (PanelRenderedBlock block : blocks) {
			tdBodys.add(block.body);
		}
		getOut().println(enhanceProperty(id, "trClassModel", Util.strings.isEmpty(bodyStyleClasses)? Arrays.asList(""):Arrays.asList(bodyStyleClasses.split(","))));
		getOut().println(enhanceProperty(id, "tdClassModel", Arrays.asList("")));
		getOut().println(enhanceProperty(id, "dataModel", tdBodys));
		getOut().println(enhanceProperty(id, "indexName", "{index}"));
		getOut().println(enhanceProperty(id, "indexPlusName", "{indexplus}"));
		includeTextTemplate("newLineFunction");
		getOut().println("</script>");
	}

	private void renderHeader() throws ELException, IOException, JspException {
		String styleString = headerStyle!=null?" style=\""+headerStyle+"\"":"";
		String classString = headerStyleClass!=null?" class=\""+headerStyleClass+"\"":"";
		getOut().print("<thead>"); //modificado por pedro para suportar o plugin do jquery para dar trace na tabela
		getOut().print("<tr"+styleString+classString+">");
		doBody();
		getOut().print("</tr>");
		getOut().print("</thead>");
	}
	
//	private void doColumns() throws JspException, IOException {
//		for (ColumnTag column : columns) {
//			column.doTag();
//		}
//	}

	protected void renderBody(Object current) throws ELException, IOException, JspException {
		String style = bodyStyleIterator.next();
		String styleClass = bodyStyleClassIterator.next();
		String styleString = style!=null?" style=\""+style+"\"":"";
		String classString = styleClass!=null?" class=\""+styleClass+"\"":"";
		if(hasColumns){
			String daattributes = "";
			Set<String> attributes = rowAttributes.keySet();
			for (String attr : attributes) {
				daattributes+=" "+attr+"=\""+escape(rowAttributes.get(attr).next())+"\"";
			}
			renderRow(styleString, classString, daattributes, current);			
		} else {
			doBody();
		}
	}

	protected void renderRow(String styleString, String classString, String daattributes, Object current) throws IOException, JspException {
		getOut().print("<tr"+styleString+classString+daattributes+">");
		doBody();
		getOut().print("</tr>");
	}

	private void renderFooter() throws ELException, IOException, JspException {
		String styleString = footerStyle!=null?" style=\""+footerStyle+"\"":"";
		String classString = footerStyleClass!=null?" class=\""+footerStyleClass+"\"":"";
		getOut().print("<tr"+styleString+classString+">");
		doBody();
		getOut().print("</tr>");
	}


	@SuppressWarnings("unchecked")
	private void iterate(Collection collection) throws ELException, IOException, JspException {
		_isFirst = true;
		Iterator iterator = collection.iterator();
		while(iterator.hasNext()){
			_current = iterator.next();
			getRequest().setAttribute(var, _current);
			getRequest().setAttribute(varIndex, _index);
			getRequest().setAttribute(varRowIndex, _index+1);
			renderBody(_current);
			_index++;
		}
		_current = null;
		getRequest().setAttribute(var, null);
		getRequest().setAttribute(varIndex, null);
	}

	public void registerColumn(ColumnTag columnTag){
		this.columns.add(columnTag);
	}
	
	private LoopTagStatus getLoopTagStatus() {
		return new LoopTagStatus(){

			public Object getCurrent() {
				return DataGridTag.this._current;
			}

			public int getIndex() {
				return DataGridTag.this._index;
			}

			public int getCount() {
				return DataGridTag.this._count;
			}

			public boolean isFirst() {
				return DataGridTag.this._isFirst;
			}

			public boolean isLast() {
				return DataGridTag.this._isLast;
			}

			public Integer getBegin() {
				return DataGridTag.this._begin;
			}

			public Integer getEnd() {
				return DataGridTag.this._end;
			}

			public Integer getStep() {
				return DataGridTag.this._step;
			}
			
		};
	}

	private CyclicIterator getBodyStyleClasses() {
		if(Util.strings.isEmpty(bodyStyleClasses)) return new CyclicIterator(null);
		return new CyclicIterator(bodyStyleClasses.split(","));
	}
	
	private CyclicIterator getBodyStyles() {
		if(Util.strings.isEmpty(bodyStyles)) return new CyclicIterator(null);
		return new CyclicIterator(bodyStyles.split(","));
	}

	public Status getCurrentStatus() {
		return currentStatus;
	}

	public String getFooterStyle() {
		return footerStyle;
	}

	public String getFooterStyleClass() {
		return footerStyleClass;
	}

	public String getHeaderStyle() {
		return headerStyle;
	}

	public String getHeaderStyleClass() {
		return headerStyleClass;
	}

	public Object getItens() {
		return itens;
	}

	public void setBodyStyleClasses(String bodyStyleClasses) {
		this.bodyStyleClasses = bodyStyleClasses;
	}

	public void setBodyStyles(String bodyStyles) {
		this.bodyStyles = bodyStyles;
	}

	public void setFooterStyle(String footerStyle) {
		this.footerStyle = footerStyle;
	}

	public void setFooterStyleClass(String footerStyleClass) {
		this.footerStyleClass = footerStyleClass;
	}

	public void setHeaderStyle(String headerStyle) {
		this.headerStyle = headerStyle;
	}

	public void setHeaderStyleClass(String headerStyleClass) {
		this.headerStyleClass = headerStyleClass;
	}

	public void setItens(Object itens) {
		this.itens = itens;
	}


	public String getVar() {
		return var;
	}


	public String getVarStatus() {
		return varStatus;
	}


	public void setVar(String var) {
		this.var = var;
	}


	public void setVarStatus(String varStatus) {
		this.varStatus = varStatus;
	}

	public boolean isRenderBody() {
		return renderBody;
	}

	public boolean isRenderFooter() {
		return renderFooter;
	}

	public boolean isRenderHeader() {
		return renderHeader;
	}

	public void setRenderBody(boolean renderBody) {
		this.renderBody = renderBody;
	}

	public void setRenderFooter(boolean renderFooter) {
		this.renderFooter = renderFooter;
	}

	public void setRenderHeader(boolean renderHeader) {
		this.renderHeader = renderHeader;
	}

	@Override
	public String getBody() throws JspException, IOException {
		// TODO Auto-generated method stub
		return super.getBody();
	}

	public Boolean getDynaLine() {
		return dynaLine;
	}

	public String getVarIndex() {
		return varIndex;
	}

	public void setDynaLine(Boolean dynaLine) {
		this.dynaLine = dynaLine;
	}

	public void setVarIndex(String varIndex) {
		this.varIndex = varIndex;
	}

	/**
	 * Adiciona um bloco para ser renderizado no detalhe
	 * @param o
	 * @return
	 */
	public boolean add(PanelRenderedBlock o) {
		return blocks.add(o);
	}

	public String enhanceProperty(String id, String propertyName, String value){
		return "document.getElementById('"+id+"')."+propertyName+" = \""+value+"\";";
	}
	
	public String enhanceProperty(String id, String propertyName, List<String> value){
		return "document.getElementById('"+id+"')."+propertyName+" = [\n"+toStringEnhancedProperty(value)+"\n];";
	}

	private String toStringEnhancedProperty(List<String> value) {
		StringBuilder builder = new StringBuilder();
		int i = 0;
		int lastIndex = value.size()-1;
		for (String string : value) {
			boolean isLast = i == lastIndex;
			string = string.replaceAll("\n", " ");
			string = string.replaceAll("\t", " ");
			string = string.replaceAll("\r", " ");
			string = escape(string.trim());
			//System.out.println(string);
			string = "\""+string+"\"";
			if(!isLast){
				string += ", \n";
			}
			builder.append(string);
			i++;
		}
		return builder.toString();
	}

	public String getVarRowIndex() {
		return varRowIndex;
	}

	public void setVarRowIndex(String varRowIndex) {
		this.varRowIndex = varRowIndex;
	}
	
	private static class CyclicIterator implements Iterator<String> {
		
		private String[] strings;
		int i = 0;

		public CyclicIterator(String[] strings){
			this.strings = strings;
		}

		public boolean hasNext() {
			return true;
		}

		public String next() {
			if(strings == null || strings.length == 0) return null;
			if(i >= strings.length){
				i = 0;
			}
			return strings[i++];
		}

		public String[] getStrings() {
			return strings;
		}

		public void remove() {
		}


	}

	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public String getStyleClass() {
		return styleClass;
	}

	public void setStyleClass(String styleClass) {
		this.styleClass = styleClass;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public void setHasColumns(boolean b) {
		this.hasColumns  = b;
		
	}

	public String getRow() {
		return row;
	}

	public String getRowSeparator() {
		return rowSeparator;
	}

	public void setRow(String row) {
		this.row = row;
	}

	public void setRowSeparator(String rowSeparator) {
		this.rowSeparator = rowSeparator;
	}

	public Object getItemType() {
		return itemType;
	}

	public void setItemType(Object itemType) {
		this.itemType = itemType;
	}
}


