/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import java.util.ArrayList;
import java.util.List;

import br.com.linkcom.neo.controller.MultiActionController;
import br.com.linkcom.neo.view.util.FunctionCall;
import br.com.linkcom.neo.view.util.FunctionParameter;
import br.com.linkcom.neo.view.util.ParameterType;

/**
 * @author rogelgarcia
 * @since 06/02/2006
 * @version 1.1
 */
public class ComboReloadGroupTag extends BaseTag implements LogicalTag{
	
	public static final String CLASS_SEPARATOR = ";";
	public static final String PARAMETRO_SEPARATOR = "#";

	private List<PropertyCall> propertyCalls = new ArrayList<PropertyCall>();
	
	protected String functionName;	
	
	protected Boolean useAjax = false;
	
	protected InputTag lastInput;
	
	public Boolean getUseAjax() {
		return useAjax;
	}

	public void setUseAjax(Boolean useAjax) {
		this.useAjax = useAjax;
	}
	
	public String getFunctionName() {
		return functionName;
	}

	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}
	
	/**
	 * Retorna o input anterior a <i>tag</i>
	 * @param tag
	 * @return
	 */
	public InputTag getLastInput(InputTag tag) {
		InputTag retorno = lastInput;
		lastInput = tag;
		return retorno;
	}
	
	public void registerProperty(String name, FunctionCall call, Boolean includeBlank) {
		List<String> dependencies = new ArrayList<String>();
		if(call == null){
			if(lastInput != null){
				dependencies.add(lastInput.getName());
			}
		} else {
			FunctionParameter[] parameterArray = call.getParameterArray();
			for (FunctionParameter parameter : parameterArray) {
				if(parameter.getParameterType() == ParameterType.REFERENCE){
					dependencies.add(parameter.getParameterValue());
				}
			}
		}
		PropertyCall propertyCall = new PropertyCall(name, call, includeBlank, dependencies.toArray(new String[dependencies.size()]));
		propertyCalls.add(propertyCall);
	}
	
	StringBuilder builder = new StringBuilder();
	
	private void println(String code){
		builder.append(code+"\n");
	}
	
	@Override
	protected void doComponent() throws Exception {
		functionName = "comboReload"+generateUniqueId();
		doBody();
		FormTag formTag = findParent(FormTag.class, true);
		String form = formTag.getName();
		println("<script language='javascript'>");
		println("    function "+functionName+"(prop, value) {");
		for (PropertyCall propertyCall : propertyCalls) {

			println("        if("+ifDependencies(propertyCall)+"){");
			if(useAjax){
				//println("		     registerLoad('"+form+"', '"+propertyCall.property+"');");
				println("		     "+form+"['"+propertyCall.property+"'].loadItens();");	
			} else {
				println("		     "+functionName+"_reload();");
			}
			
			println("        }");
		}
		println("    }");
		
		String url = formTag.getUrl();
		String action;
		if (formTag.getAction() != null) {
			action = formTag.getAction();
		} else {
			action = "";
		}
		println("    function "+functionName+"_reload() {");
		println("\n        "+formTag.getName()+".action = '"+url+"'; ");
		println("\n        "+formTag.getName()+"."+MultiActionController.ACTION_PARAMETER+".value = '"+action+"';");
		println("\n        "+formTag.getName()+".validate = 'false';");
		println("\n        "+formTag.getName()+".suppressErrors.value = 'true';");
		println("\n        "+formTag.getName()+".suppressValidation.value = 'true';");		
		println("\n        "+formTag.getSubmitFunction()+"();");
		println("\n   }");
		println("\n");
		
		println("</script>");
		getOut().println(builder.toString());
	}
	
	private String ifDependencies(PropertyCall propertyCall) {
		String expression = "";
		
		for (String dependencia : propertyCall.dependencies) {
			boolean bypass = false;
			
			
			//se a propriedade em questao tiver outra dependencia (sem ser a em questao)
			//e essa outra dependencia tambm depender da dependencia em questao
			//e essa outra dependencia for includeBlank false... passar essa dependencia
			//exemplo
			// temos propriedade A
			// temos propriedade B que depende de A e includeBlank = false
			// temos propriedade C que depende de B e depende de A 
			// quando a propriedade A for mudada no deve ser recarregado o combo C
			// isso, porque o combo A modificar o combo B que por ser includeBlank = false j ir modificar o combo C
			for (String dependencia2 : propertyCall.dependencies) {
				if(dependencia2 != dependencia){
					PropertyCall propertyCallDependencia2 = getPropertyCall(dependencia2);
					if(propertyCallDependencia2 != null){
						if(Boolean.FALSE.equals(propertyCallDependencia2.includeBlank)){
							String[] dependencies2 = propertyCallDependencia2.dependencies;
							for (String dependencie2 : dependencies2) {
								if(dependencie2.equals(dependencia)){
									bypass = true;
								}
							}
						}
					}
				}
			}

			if(!bypass){
				expression += "prop == '"+dependencia+"' || ";	
			}
		}
		expression += " 0 == 1";
		return expression;
	}

	private PropertyCall getPropertyCall(String dependencia) {
		PropertyCall propertyCallDependencia2 = null;
		for (PropertyCall teste : propertyCalls) {
			if(teste.property.equals(dependencia)){
				propertyCallDependencia2 = teste;
				break;
			}
		}
		return propertyCallDependencia2;
	}

	class PropertyCall{
		String property;
		FunctionCall call;
		String[] dependencies;
		Boolean includeBlank;
		public PropertyCall(String property, FunctionCall call, Boolean includeBlank, String... dependencies) {
			super();
			this.property = property;
			this.call = call;
			this.dependencies = dependencies;
			this.includeBlank = includeBlank;
		}
	}
	/*
	 * COMBO RELOAD ANTIGO
	 *
	public static final String CLASS_SEPARATOR = ";";
	public static final String PARAMETRO_SEPARATOR = "#";
	protected List<ReloadItem> itens = new ArrayList<ReloadItem>();
	
	class ReloadItem {
		String property;
		Boolean useAjax;
		String loadFunction;
		Class clazz;
		String label;
		Boolean includeBlank;
		FunctionCall functionCall;
		FunctionCallInfo functionCallInfo;
		String onLoadItens;
		Boolean autoSugest;
	}
	
	protected String functionName;	
	protected String functionString;
	
	protected InputTag lastInput;
	
	protected Boolean useAjax = false;
	
	public Boolean getUseAjax() {
		return useAjax;
	}

	public void setUseAjax(Boolean useAjax) {
		this.useAjax = useAjax;
	}


	/**
	 * Retorna o input anterior ao <i>tag</i>
	 * @param tag
	 * @return
	 *
	public InputTag getLastInput(InputTag tag) {
		InputTag retorno = lastInput;
		lastInput = tag;
		return retorno;
	}
	
	
	public String getFunctionName() {
		return functionName;
	}

	public void setFunctionName(String functionName) {
		this.functionName = functionName;
	}

	@Override
	protected void doComponent() throws Exception {
		functionName = "comboReload"+generateUniqueId();
		doBody();
		FormTag formTag = findParent(FormTag.class, true);
		StringBuilder builder = new StringBuilder();
		builder.append("<script language='javascript'>");
		builder.append("\n");
		builder.append("    function "+functionName+"_lock() {");
		for (ReloadItem it : itens) {
			builder.append("\n");
			builder.append("        "+formTag.getName()+"['"+it.property+"'].disabled = true;");
		}
		builder.append("\n");
		builder.append("}");
		
		builder.append("\n");
		builder.append("    function "+functionName+"_unlock() {");
		for (ReloadItem it : itens) {
			builder.append("\n");
			builder.append("        "+formTag.getName()+"['"+it.property+"'].disabled = false;");
		}
		builder.append("\n");
		builder.append("}");
		
		builder.append("\n");
		builder.append("    function "+functionName+"(prop, value) {");
		builder.append("\n");
		//builder.append("        alert('Reload '+prop);");
		
		if (itens.size() > 0) {
			builder.append("        if(prop == '" + itens.get(itens.size() - 1).property + "'){return;}");
			builder.append("\n");
			int i = 1;
			for (ReloadItem it : itens) {
				builder.append("        if(prop == '" + it.property + "'){");
				builder.append("\n");
				List<ReloadItem> subList = itens.subList(i, itens.size());
				
				for (ReloadItem item : subList) {
					
					builder.append("            " + formTag.getName() + "['" + item.property + "'].selectedIndex = 0;");
					builder.append("\n");
				}
				Boolean usingAjax = false;
				if(i < itens.size()){
					usingAjax = itens.get(i).useAjax;
				}
				if(usingAjax){
					Boolean includeBlank =  itens.get(i).includeBlank;
					String className =      itens.get(i).clazz.getName();
					String property =       itens.get(i).property;
					String label =          itens.get(i).label;
					String parentProperty = itens.get(i-1).property;
					String loadFunction =   itens.get(i).loadFunction;
					String onLoadItens =    itens.get(i).onLoadItens.replace((CharSequence)"'", "\\'");
					Boolean autosugest = itens.get(i).autoSugest == null?false:itens.get(i).autoSugest;
					if(includeBlank == null){
						includeBlank = true;
					}
					 
					
					for (ReloadItem item : subList) {						
						builder.append("               limparCombo(" + formTag.getName() + "['" + item.property + "'], "+(includeBlank)+");");
						builder.append("\n");
					}
					
					builder.append("            if(value != null && value != '<null>') {");
					builder.append("\n");
				
					FunctionCall functionCall = itens.get(i).functionCall;
					FunctionCallInfo functionCallInfo = itens.get(i).functionCallInfo;
					String listaParametrosFuncao = "var listaParametros = '";
					String listaClassesFuncao = "var listaClasses = '";
					if(functionCall !=null && functionCall.getParameterArray().length > 0){
						
						FunctionParameter[] parameterArray = functionCall.getParameterArray();
						for (int j = 0; j < parameterArray.length; j++) {
							//boolean hasNext = j+1 < functionCall.getParameterArray().length;
							String param = functionCall.getParameterArray()[j].getParameterValue();
							switch(functionCall.getParameterArray()[j].getParameterType()){							
								case REFERENCE:
									listaParametrosFuncao += "'+"+formTag.getName()+ "['"+param+"'].value+'";
									listaClassesFuncao += functionCallInfo.getType(functionCall.getParameterArray()[j]).getName();
									listaClassesFuncao += CLASS_SEPARATOR;
									listaParametrosFuncao += PARAMETRO_SEPARATOR;
									break;
								case STRING:
									listaParametrosFuncao += param;
									listaClassesFuncao += String.class.getName();
									listaClassesFuncao += CLASS_SEPARATOR;
									listaParametrosFuncao += PARAMETRO_SEPARATOR;
									break;	
								case BOOLEAN:
									listaParametrosFuncao += param;
									listaClassesFuncao += Boolean.class.getName();
									listaClassesFuncao += CLASS_SEPARATOR;
									listaParametrosFuncao += PARAMETRO_SEPARATOR;
									break;		
								case USER:
									listaParametrosFuncao += param;
									listaClassesFuncao += User.class.getName();
									listaClassesFuncao += CLASS_SEPARATOR;
									listaParametrosFuncao += PARAMETRO_SEPARATOR;
									break;	
								default:
									throw new RuntimeException("Tipo no suportado: "+functionCall.getParameterArray()[j].getParameterType());
							}
						}
					}
					listaParametrosFuncao += "';";
					listaClassesFuncao += "';";
					builder.append("                "+listaParametrosFuncao);
					builder.append("\n");
					builder.append("                "+listaClassesFuncao);
					builder.append("\n");
					
					//builder.append("                alert('using ajax to load \\'"+properties.get(i)+"\\' ... "+properties.get(i-1)+"='+value+' \\nUsing function: "+propertiesLoadFunction.get(i)+"');");
					//o campo value  o valor do combo anterior
					builder.append("                ajaxLoadCombo('"+getRequest().getContextPath()+"', '"+formTag.getName()+"', '"+className+"', '"+property+"', '"+label+"', '"+parentProperty+"', value, '"+Util.strings.escape(loadFunction)+"', "+includeBlank+", listaParametros, listaClasses, '"+functionName+"', '"+onLoadItens+"', "+autosugest+");");
					builder.append("\n");
					builder.append("            }");
				}else {
					builder.append("            "+functionName+"_reload(prop);");
				}
				builder.append("\n");
				builder.append("        }");
				builder.append("\n");
				i++;
			}
		}
		String url = formTag.getUrl();
		String action;
		if (formTag.getAction() != null) {
			action = formTag.getAction();
		} else {
			action = "";
		}
		
		builder.append("\n");
		builder.append("    }");
		builder.append("\n");
		builder.append("    function "+functionName+"_reload(prop) {");
		builder.append("\n        "+formTag.getName()+".action = '"+url+"'; ");
		builder.append("\n        "+formTag.getName()+"."+MultiActionController.ACTION_PARAMETER+".value = '"+action+"';");
		builder.append("\n        "+formTag.getName()+".validate = 'false';");
		builder.append("\n        "+formTag.getName()+".suppressErrors.value = 'true';");
		builder.append("\n        "+formTag.getName()+".suppressValidation.value = 'true';");		
		builder.append("\n        "+formTag.getSubmitFunction()+"();");
		builder.append("\n");
		builder.append("	}");
		builder.append("\n");		
		builder.append("</script>");
		builder.append("\n");
		functionString = builder.toString();
		getOut().println(functionString);
	}

	
	public void registerProperty(Class usingType, String name, Boolean useAjax, String loadFunction, String label, boolean includeBlank, FunctionCall call, FunctionCallInfo callInfo, String onLoadItens, Boolean autoSugestUniqueItem){
		ReloadItem item = new ReloadItem();
		item.property = name;
		if(useAjax == null){
			item.useAjax = this.useAjax;
		} else {
			item.useAjax = useAjax;
		}
		item.loadFunction = loadFunction;
		item.clazz = usingType;
		item.label = label;
		item.includeBlank = includeBlank;
		item.functionCall = call;
		item.functionCallInfo = callInfo;
		item.onLoadItens = onLoadItens;
		item.autoSugest = autoSugestUniqueItem;
		itens.add(item);
	}
	*/
}
