/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.exception.BeanDescriptorCreationException;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.view.DataGridTag.Status;

/**
 * @author rogelgarcia
 * @since 26/01/2006
 * @version 1.1
 */
public class BeanTag extends BaseTag implements LogicalTag {
	
	protected String name;
	protected String propertyPrefix;
	protected String propertyIndex;
	protected Class valueType;
	protected String varLabel = "label";
	
	//extras
	protected Object bean;
	protected BeanDescriptor beanDescriptor;

	public BeanDescriptor getBeanDescriptor() {
		return beanDescriptor;
	}


	@Override
	@SuppressWarnings("unchecked")
	protected void doComponent() throws Exception {
		bean = getPageContext().getExpressionEvaluator().evaluate("${"+name+"}", valueType == null? Object.class : valueType, getPageContext().getVariableResolver(), null);	
		if(bean == null && getParent() instanceof DataGridTag){
			DataGridTag dataGridTag = (DataGridTag) getParent();
			if(dataGridTag.currentStatus == Status.DYNALINE){
				//se estiver renderizando um dynaline e no tiver bean no escopo.. instanciar um
				bean = valueType.newInstance();
			}
		}
		try {
			beanDescriptor = NeoWeb.getWebApplicationContext(getServletContext()).getBeanDescriptor(bean, valueType);
		} catch (BeanDescriptorCreationException e) {
			String msg = "Problema na tag bean (name='"+name+"'). ";
			if(valueType == null){
				msg += "Talvez seja necessrio informar o atributo valueType. ";
			}
			throw new NeoException(msg+e.getMessage(), e);
		}
		pushAttribute(varLabel, beanDescriptor.getDisplayName());
		doBody();
		popAttribute(varLabel);
	}


	public String getName() {
		return name;
	}


	public String getPropertyIndex() {
		return propertyIndex;
	}


	public String getPropertyPrefix() {
		return propertyPrefix;
	}


	public Class<?> getValueType() {
		return valueType;
	}


	public void setName(String name) {
		this.name = name;
	}


	public void setPropertyIndex(String propertyIndex) {
		this.propertyIndex = propertyIndex;
	}


	public void setPropertyPrefix(String propertyPrefix) {
		this.propertyPrefix = propertyPrefix;
	}


	public void setValueType(Class<?> valueType) {
		this.valueType = valueType;
	}


	public String getVarLabel() {
		return varLabel;
	}


	public void setVarLabel(String varLabel) {
		this.varLabel = varLabel;
	}

}
