/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.validation;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.NotReadablePropertyException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.core.web.WebRequestContext;

/**
 * Valida um objeto baseado nas suas anotaes
 * @author rogelgarcia
 *
 */
public class ObjectAnnotationValidator extends WebApplicationObjectSupport implements Validator {
	
	//private static final Log log = LogFactory.getLog(ObjectAnnotationValidator.class);
	
	protected WebRequestContext context;


	public ObjectAnnotationValidator(WebRequestContext context) {
		this.context = context;
	}

	public boolean supports(Class clazz) {
		// suporta todas as classes
		return true;
	}

	@SuppressWarnings("unchecked")
	public void validate(Object obj, Errors errors) {
		WebApplicationContext webApplicationContext = context.getWebApplicationContext();
		ValidatorRegistry validatorRegistry = webApplicationContext.getConfig().getValidatorRegistry();
		HttpServletRequest servletRequest = context.getServletRequest();
		//ValidatorAnnotationExtractor extractor = validatorRegistry.getExtractor();
		//validar arquivos
		if(servletRequest instanceof MultipartHttpServletRequest){
			MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)servletRequest;
			Iterator fileNames = multipartHttpServletRequest.getFileNames();
			while(fileNames.hasNext()){
				String filename = (String) fileNames.next();
				MultipartFile file = multipartHttpServletRequest.getFile(filename);
				if(file.getOriginalFilename() != null && file.getOriginalFilename().length() > 0){
					if(file.getSize() == 0){
						errors.reject("", "O arquivo '"+filename+"' no pode ter tamanho 0 (zero)");
					}	
				}
				
			}
		}
		Map<String, String> parameterMap = servletRequest.getParameterMap();
		Set<String> keySet = parameterMap.keySet();
		BeanDescriptor<Object> beanDescriptor = webApplicationContext.getBeanDescriptor(obj);
		for (String parametro : keySet) {
			if(parametro.startsWith("_")){
				parametro = parametro.substring(1);
			}
			PropertyDescriptor propertyDescriptor;
			try {
				propertyDescriptor = beanDescriptor.getPropertyDescriptor(parametro);
			} catch (NotReadablePropertyException e) {
				// se nao for uma propriedade do bean.. nao fazer nada
				continue;
			}
			//System.out.println("Validando ... "+propertyDescriptor.getDisplayName());
			Annotation[] annotations = propertyDescriptor.getAnnotations();
			for (Annotation annotation : annotations) {
				PropertyValidator propertyValidator = validatorRegistry.getPropertyValidator(annotation.annotationType());
				if(propertyValidator != null){
					propertyValidator.validate(obj, propertyDescriptor.getValue(), parametro, propertyDescriptor.getDisplayName(), annotation, errors, this);
				}
			}
		}
	}

//	public void validateIndexed(Object obj, Errors errors, String nestedPath){
//		Class objClass = obj.getClass();
//		
//		List<ValidationItem> validationItens = extractor.getValidationItens(objClass);
//		
//		for (ValidationItem item : validationItens) {
//			try {
//				//Method method = item.getMethod();
//				//Object value = method.invoke(obj);
//				List<Annotation> validations = item.getValidations();
//				for (Annotation validation : validations) {
//					PropertyValidator validator = extractor.getValidatorRegistry().getPropertyValidator(validation.annotationType());
//					
//					
//					String fieldDisplayName = null;
//					if(nestedPath == null){
//						fieldDisplayName = item.getFieldName();	
//					} else {
//						fieldDisplayName = item.getFieldName() + " em " + StringUtils.uncapitalize(nestedPath);
//					}
//					
//					//validator.validate(obj, value, item.getFieldName(), fieldDisplayName, validation, errors, this);
//				}
//			} catch (Exception e) {
//				errors.reject("validation.error", new Object[]{e}, "No foi possvel efetuar a validao");
//			}
//		}
//	}

	
}
