/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import javax.servlet.http.HttpServletRequest;

import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebRequestContext;

/**
 * @author rogelgarcia
 * @since 25/01/2006
 * @version 1.1
 */
public class WebUtils {

	public String getFullUrl(HttpServletRequest request){
		String path = request.getServletPath()+request.getPathInfo();
		return getFullUrl(request, path);
	}

	public String getFullUrl(HttpServletRequest request, String path) {
		String contextPath = request.getContextPath();
		return contextPath+path;
	}
	
	public String getFirstFullUrl(){
		return ((WebRequestContext)NeoWeb.getRequestContext()).getServletRequest().getContextPath()+((WebRequestContext)NeoWeb.getRequestContext()).getFirstRequestUrl();
	}
	
	public String getFirstUrl(){
		return ((WebRequestContext)NeoWeb.getRequestContext()).getFirstRequestUrl();
	}
}
