/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.core.standard.Neo;

/**
 * @author rogelgarcia
 * @since 22/01/2006
 * @version 1.1
 */
public class StringUtils {

	public String uncaptalize(String str){
		return org.apache.commons.lang.StringUtils.uncapitalize(str);
	}
	
	public String captalize(String str){
		return org.apache.commons.lang.StringUtils.capitalize(str);
	}

	public boolean isEmpty(String str) {
		return str == null || str.equals("");
	}
	
	public boolean isNotEmpty(String str) {
		return !isEmpty(str);
	}

	/**
	 * Separa parametros no formato key=value;
	 * @param parameters
	 * @return
	 */
	public Map<String, String> parseParameters(String parameters) {
		HashMap<String, String> hashMap = new HashMap<String, String>();
		if(parameters == null){
			
			return hashMap;
		}
		String[] split = parameters.split(";");
		for (String string : split) {
			String[] split2 = string.split("=");
			if(split2.length != 2){
				throw new RuntimeException("Parametros invlidos: "+parameters);
			}
			hashMap.put(split2[0], split2[1]);
		}
		return hashMap;
	}

	/**
	 * Separa as palavras da string toda vez que trocar o case
	 * @param string
	 * @return
	 */
	public String separateOnCase(String string) {
		char[] toCharArray = string.substring(1).toCharArray();
		StringBuilder builder = new StringBuilder();
		builder.append(string.charAt(0));
		for (char c : toCharArray) {
			if(Character.isUpperCase(c)){
				builder.append(" ");
			}
			builder.append(c);
		}
		return builder.toString();
	}
	
	
	/**
	 * Cria uma string com o nome da classe e o parametro id
	 * Ex.: pacote.Classe[campoid=5]
	 * @param o
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public String toStringIdStyled(Object o){
		return toStringIdStyled(o, false);
	}
	
	@SuppressWarnings("unchecked")
	public String toStringIdStyled(Object o, boolean includeDescription){
		if(o == null){
			return "<null>";
		}
		BeanDescriptor beanDescriptor = Neo.getApplicationContext().getBeanDescriptor(o);
		String idProperty = beanDescriptor.getIdPropertyName();
		if(idProperty == null){
			//CODIGO INSERIDO EM 16 DE NOVEMBRO DE 2006 PARA O AJAX SUPORTAR LISTAS QUE NAO SO DE BENAS (EX LISTA DE INTEIROS)
			return o.toString();
		}
		Object value = beanDescriptor.getId();
		
			
		StringBuilder stringBuilder = new StringBuilder();
		Class clazz = o.getClass();
		while(clazz.getName().contains("$$")){
			clazz = clazz.getSuperclass();
		}
		stringBuilder.append(clazz.getName());
		stringBuilder.append("[");
		
		stringBuilder.append(idProperty);
		stringBuilder.append("=");
		stringBuilder.append(value);
		
		if(includeDescription){
			Object description = beanDescriptor.getDescription();
			if(description != null){
				String descriptionPropertyName = beanDescriptor.getDescriptionPropertyName();
				stringBuilder.append(",");
				stringBuilder.append(descriptionPropertyName);
				stringBuilder.append("=");
				stringBuilder.append(description);
			}
		}
		stringBuilder.append("]");
		return stringBuilder.toString();
	}

	@SuppressWarnings("unchecked")
	public String toStringDescription(Object value) {
		BeanDescriptor beanDescriptor = null;
		{
			if (value == null) {
				return "";
			}
			if(value instanceof Date){
				DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
				return dateFormat.format(value);
			}
			beanDescriptor = Neo.getApplicationContext()
					.getBeanDescriptor(value);
			Object description = beanDescriptor.getDescription();
			if (description == null) {
				//CDIGO ALTERADO EM 16 DE NOVEMBRO DE 2006
				//description = value.toString();
				// CDIGO ALTERADO EM 05 DE DEZEMBRO DE 2006
				// MOTIVO: O CDIGO ANTERIOR IMPRIMIA:   br....Aluno@93CD21
				if(beanDescriptor.getDescriptionPropertyName() == null){
					description = value.toString();
				} else {
					description = "";	
				}
			}
			return description.toString();
		}
	}

    public String tiraAcento(String string) {
        return org.apache.commons.lang.StringUtils.replaceChars(string, "", "AEIOUAEIOUAEIOUAEIOUAOCaeiouaeiouaeiouaeiouaoc");
    }

	public String toString(Object o) {
		if(o == null){
			return null;
		} else {
			if(o instanceof Double){
				return new DecimalFormat("#,##0.00").format((Double)o);
			}
			return o.toString();
		}
	}

	public String toString(Object o, String def) {
		if(o == null){
			return def;
		} else {
			return o.toString();
		}
	}

	/**
	 * Faz o escape de aspas simples
	 * @param string
	 * @return
	 */
	public String escape(String string) {
		if(string == null){
			return "";
		}
		return string.replaceAll("'", "\\\\'");
	}
	
	public static String soNumero(String s) {
		int i;
		String numeros  = "0123456789";
		int tamanho     = s.length();			
		StringBuilder sb = new StringBuilder();
		String caractere= "";		
		for (i = 0; i < tamanho; i++) {
			caractere = s.substring(i,i + 1);
			if (numeros.indexOf(caractere) != -1)
				sb.append(caractere);
		} 
		return sb.toString();
	} //SoNumero
	
	public static String stringCheia(String s, String c, int tamanho, boolean direita) {
		if (s == null){
			s = "";
		}
		String result = s;
		if (c==null){
			c = "";
		}
		if (c.equals("")) 
			c += "0";		
		while (result.length() < tamanho) {
			if (direita) 
				result += c;
			else
				result  = c + result;
		}
		if (result.length() > tamanho) {
			if (direita) 
				result = result.substring(0,tamanho);
			else
				result = result.substring(result.length() - tamanho, result.length());
		}
		return result.toUpperCase();
	} //StringCheia

	public String emptyIfNull(String propertyPrefix) {
		return propertyPrefix != null? propertyPrefix : "";
	}


}
