/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

import br.com.linkcom.neo.core.web.NeoWeb;

/**
 * @author pedro.goncalves
 * @since 26/06/2007
 * @version 1.0
 */
public class LocaleUtils {
	
	public static final String LOCALE_SESSION_KEY = "NEO_LOCALE";
	
	public Locale getLocaleSelected() {
		HttpServletRequest request = NeoWeb.getRequestContext().getServletRequest();
		String usrLocale = (String)request.getSession().getAttribute(LOCALE_SESSION_KEY);
		
		Locale localeUser = null;
		
		if (usrLocale == null) {
			localeUser = request.getLocale();
		} else {
			if (usrLocale.length() == 5) {
				localeUser = new Locale(usrLocale.substring(0,2), usrLocale.substring(3,5));
			} else {
				localeUser = request.getLocale();
			}
		}
		
		return localeUser;
	}
	
	public String getBundleKey(String key) {
		Locale localeSelected = getLocaleSelected();
		ResourceBundle bundle = null;
		try {
			bundle = ResourceBundle.getBundle("i18n",localeSelected);
		} catch (MissingResourceException e) {
			return null;
		}
		String value = null;
		try {
			value = bundle.getString(key);
		} catch (MissingResourceException e) {
			return null;
		}	

		return value;
	}
}
