/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author rogelgarcia
 * @since 01/02/2006
 * @version 1.1
 */
public class GenericsUtils {
	
	public Class[] getGenericTypes(Class<?> clazz) {
		TypeVariable[] typeVariables = clazz.getTypeParameters();

		List<Class> lista = new ArrayList<Class>();
		for (TypeVariable variable : typeVariables) {
			lista.add((Class) variable.getBounds()[0]);
		}
		return lista.toArray(new Class[lista.size()]);
	}

	public Class[] getGenericTypes2(Class<?> clazz) {
		try {
			ParameterizedType genericSuperclass = (ParameterizedType) clazz.getGenericSuperclass();
			Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
			Class[] array = new Class[actualTypeArguments.length];
			for (int i = 0; i < actualTypeArguments.length; i++) {
				Type type = actualTypeArguments[i];
				array[i] = (Class) type;
			}
			return array;
		} catch (Exception e) {
			throw new RuntimeException("No foi possvel descobrir o tipo genrico da classe "+clazz);
		}
	}

	public Class[] getActualClassesArgument(ParameterizedType type) {
		Type[] actualTypeArguments = type.getActualTypeArguments();
		Class[] actualClassesArguments = new Class[actualTypeArguments.length];
		for (int i = 0; i < actualTypeArguments.length; i++) {
			Type type2 = actualTypeArguments[i];
			if(type2 instanceof Class){
				actualClassesArguments[i] = (Class)type2;
			} else if(type2 instanceof ParameterizedType){
				actualClassesArguments[i] = (Class)((ParameterizedType)type2).getRawType();
			} else {
				throw new RuntimeException("Erro ao conseguir a lista de classes parametrizadas da classe "+type);
			}
		}
		return actualClassesArguments;
	}
}
