/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import br.com.linkcom.neo.core.standard.Neo;


/**
 * @author Pedro Gonalves
 * @since 09/11/2007
 * @version 1.0
 */
public class ConfigUtil {
	private static final Log log = LogFactory.getLog(ConfigUtil.class);
	
	/**
	 * Pega um atributo do arquivo de configurao do NEO que  boolean. 
	 * Caso o atributo no esteja configurado ele usa o valor
	 * default estabelecido no primeiro argumento
	 * 
	 * @param defaultValue - Valor default
	 * @param configname - nome do parmetro do config
	 * @author Pedro
	 * @see br.com.linkcom.neo.core.standard.ApplicationContext#getConfig()
	 * @return
	 */
	public boolean getDefaultConfigBoolean(Boolean defaultValue, String configname){
		String configvalue = Neo.getApplicationContext().getConfig().getProperties().getProperty(configname);
		if(configvalue == null ) return defaultValue;
		else {
			try {
				return Boolean.parseBoolean(configvalue);
			} catch (Exception e) {
				log.warn("No foi possvel converter a configurao "+configname + " para um Boolean. Utilizando configurao default.");
				return defaultValue;
			}
		}
	}
}
