/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.util;

import java.util.Map;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

/**
 * @author rogelgarcia
 * @since 22/01/2006
 * @version 1.1
 */
public class BeanFacotryUtils {

	public boolean containsBeanOfClass(ConfigurableListableBeanFactory beanFactory, Class<?> beanClass){
		Map<?, ?> map = beanFactory.getBeansOfType(beanClass);
		return !map.isEmpty();
	}
	
	/**
	 * Registra um bean na fabrica. O bean ser configurado com AUTOWIRE BY TYPE.
	 * O nome do bean ser o nome da classe
	 * @param beanFactory
	 * @param beanClass
	 */
	public void registerBean(ConfigurableListableBeanFactory beanFactory, Class beanClass){
		MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
		RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass, mutablePropertyValues);
		beanDefinition.setAutowireMode(DefaultListableBeanFactory.AUTOWIRE_BY_TYPE);
		String beanName = Util.strings.uncaptalize(beanClass.getSimpleName());
		((DefaultListableBeanFactory)beanFactory).registerBeanDefinition(beanName, beanDefinition);
	}
	
	
	public void registerBean(ConfigurableListableBeanFactory beanFactory, Class beanClass, String name){
		MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
		RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass, mutablePropertyValues);
		beanDefinition.setAutowireMode(DefaultListableBeanFactory.AUTOWIRE_BY_TYPE);
		((DefaultListableBeanFactory)beanFactory).registerBeanDefinition(name, beanDefinition);
	}
	
	public void registerBean(ConfigurableListableBeanFactory beanFactory, Class beanClass, String name, MutablePropertyValues mutablePropertyValues){
		boolean autowire = true;
		registerBean(beanFactory, beanClass, name, mutablePropertyValues, autowire);
	}

	public void registerBean(ConfigurableListableBeanFactory beanFactory, Class beanClass, String name, MutablePropertyValues mutablePropertyValues, boolean autowire) {
		RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass, mutablePropertyValues);
		if (autowire) {
			beanDefinition.setAutowireMode(DefaultListableBeanFactory.AUTOWIRE_BY_TYPE);
		}
		((DefaultListableBeanFactory)beanFactory).registerBeanDefinition(name, beanDefinition);
	}
	
}
