/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.persistence;

import java.util.List;


public interface QueryBuilderResultTranslator<E> {

	public void init(String[] selectedProperties, AliasMap[] aliasMaps);
	
	/**
	 * No Thread-Safe a chamada deve ser synchronizada
	 * Recomendao: utilizar translate(List) que  Thread Safe
	 * @param values
	 * @return
	 */
	public E translate(Object[] values);
	
	/**
	 * Thread-Safe
	 * @param values
	 * @return
	 */
	public List<E> translate(List<Object[]> values);
		
	public String[] getExtraFields();
	
	public void setResultAlias(String resultAlias);
}
