/*
 * Neo Framework http://www.neoframework.org
 * Copyright (C) 2007 the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * You may obtain a copy of the license at
 * 
 *     http://www.gnu.org/copyleft/lesser.html
 * 
 */
package br.com.linkcom.neo.persistence;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import br.com.linkcom.neo.controller.crud.FiltroListagem;


/**
 * Cria um resultSet para ser usado na listagem
 * Atualiza o filtroListagem com o nmero de paginas e a pgina atual
 */
public class ListagemResult<E> {
	
	protected List<E> lista = null;
	@SuppressWarnings("unchecked")
	
	public ListagemResult(QueryBuilder<E> queryBuilder, FiltroListagem filtroListagem){
		init(queryBuilder, filtroListagem);
	}

	protected void init(QueryBuilder<E> queryBuilder, FiltroListagem filtroListagem) {
		QueryBuilder<Integer> countQueryBuilder = new QueryBuilder<Integer>(queryBuilder.getHibernateTemplate());
        
        String select = queryBuilder.getSelect().getValue().trim();
		if (! select.toLowerCase().startsWith("distinct")) {
			countQueryBuilder.select("count(*)");
		}
        else {
        	countQueryBuilder.select("count(" + select + ")");
        }
        QueryBuilder.From from = queryBuilder.getFrom();
        countQueryBuilder.from(from);
        
        List<QueryBuilder<E>.Join> joins = queryBuilder.getJoins();
        for (QueryBuilder.Join join : joins) {
        	//quando estiver contando nao precisa de fazer fetch do join
			countQueryBuilder.join(join.getJoinMode(), false, join.getPath());
		}
        QueryBuilder.Where where = queryBuilder.getWhere();
		countQueryBuilder.where(where);
		Integer numeroResultados = countQueryBuilder.unique();        
                
		filtroListagem.setNumberOfResults(numeroResultados.intValue());
		
		if(filtroListagem.getEVENT().equals(FiltroListagem.FILTER)){
			//se estiver filtrando novamente voltar para a primeira pgina
			filtroListagem.setCurrentPage(0);
		}
		int i = numeroResultados.intValue() / filtroListagem.getPageSize();
		if(numeroResultados.intValue() % filtroListagem.getPageSize() != 0){
			i++;
		}
		filtroListagem.setNumberOfPages(i);
		
		queryBuilder.setPageNumberAndSize(filtroListagem.getCurrentPage(), filtroListagem.getPageSize());
		if (!StringUtils.isEmpty(filtroListagem.getOrderBy())) {
			queryBuilder.orderBy(filtroListagem.getOrderBy()+" "+(filtroListagem.isAsc()?"ASC":"DESC"));
		}
		
		lista = queryBuilder.list();
	}
	
	public List<E> list(){
		return lista;
	}
}
